/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.StringOpsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0001\n\u0002\u0010\u0004\n\u0002\b\u0006\u001a\u0015\u00108\u001a\u00020\u00022\b\u00109\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010:\u001a\u0012\u00108\u001a\u00020'2\b\u00109\u001a\u0004\u0018\u00010;H\u0007\u001a\u0010\u00108\u001a\u00020\u00022\b\u00109\u001a\u0004\u0018\u00010<\u001a\u0010\u00108\u001a\u00020\u00022\b\u00109\u001a\u0004\u0018\u00010\t\u001a\u0018\u0010=\u001a\u00020;2\u0006\u0010>\u001a\u00020\t2\u0006\u0010?\u001a\u00020\tH\u0001\u001a\u0014\u0010@\u001a\u00020;*\u00020#2\u0006\u0010A\u001a\u00020\tH\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\"\u0017\u0010\b\u001a\u0004\u0018\u00010\t*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\f\u001a\u00020\r*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u0017\u0010\u0010\u001a\u0004\u0018\u00010\r*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u0015\u0010\u0013\u001a\u00020\u0014*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\"\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u0014*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\"\u0015\u0010\u001a\u001a\u00020\u001b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\"\u0017\u0010\u001e\u001a\u0004\u0018\u00010\u001b*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \"\u0015\u0010!\u001a\u00020\"*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\"\u0015\u0010&\u001a\u00020'*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\"\u0015\u0010*\u001a\u00020+*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\"\u0015\u0010.\u001a\u00020\u0002*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b/\u00100\"\u0015\u00101\u001a\u000202*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b3\u00104\"\u0017\u00105\u001a\u0004\u0018\u000102*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b6\u00107\u00a8\u0006B"}, d2={"boolean", "", "Lkotlinx/serialization/json/JsonPrimitive;", "getBoolean", "(Lkotlinx/serialization/json/JsonPrimitive;)Z", "booleanOrNull", "getBooleanOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Boolean;", "contentOrNull", "", "getContentOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/String;", "double", "", "getDouble", "(Lkotlinx/serialization/json/JsonPrimitive;)D", "doubleOrNull", "getDoubleOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Double;", "float", "", "getFloat", "(Lkotlinx/serialization/json/JsonPrimitive;)F", "floatOrNull", "getFloatOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Float;", "int", "", "getInt", "(Lkotlinx/serialization/json/JsonPrimitive;)I", "intOrNull", "getIntOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Integer;", "jsonArray", "Lkotlinx/serialization/json/JsonArray;", "Lkotlinx/serialization/json/JsonElement;", "getJsonArray", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonArray;", "jsonNull", "Lkotlinx/serialization/json/JsonNull;", "getJsonNull", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonNull;", "jsonObject", "Lkotlinx/serialization/json/JsonObject;", "getJsonObject", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonObject;", "jsonPrimitive", "getJsonPrimitive", "(Lkotlinx/serialization/json/JsonElement;)Lkotlinx/serialization/json/JsonPrimitive;", "long", "", "getLong", "(Lkotlinx/serialization/json/JsonPrimitive;)J", "longOrNull", "getLongOrNull", "(Lkotlinx/serialization/json/JsonPrimitive;)Ljava/lang/Long;", "JsonPrimitive", "value", "(Ljava/lang/Boolean;)Lkotlinx/serialization/json/JsonPrimitive;", "", "", "unexpectedJson", "key", "expected", "error", "element", "kotlinx-serialization-json"})
public final class JsonElementKt {
    @NotNull
    public static final JsonPrimitive JsonPrimitive(@Nullable Boolean value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(value, false);
    }

    @NotNull
    public static final JsonPrimitive JsonPrimitive(@Nullable Number value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(value, false);
    }

    @NotNull
    public static final JsonPrimitive JsonPrimitive(@Nullable String value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(value, true);
    }

    @ExperimentalSerializationApi
    @NotNull
    public static final JsonNull JsonPrimitive(@Nullable Void value) {
        return JsonNull.INSTANCE;
    }

    @NotNull
    public static final JsonPrimitive getJsonPrimitive(@NotNull JsonElement $this$jsonPrimitive) {
        Intrinsics.checkNotNullParameter($this$jsonPrimitive, "<this>");
        JsonPrimitive jsonPrimitive = $this$jsonPrimitive instanceof JsonPrimitive ? (JsonPrimitive)$this$jsonPrimitive : null;
        if (jsonPrimitive == null) {
            JsonElementKt.error($this$jsonPrimitive, "JsonPrimitive");
            throw new KotlinNothingValueException();
        }
        return jsonPrimitive;
    }

    @NotNull
    public static final JsonObject getJsonObject(@NotNull JsonElement $this$jsonObject) {
        Intrinsics.checkNotNullParameter($this$jsonObject, "<this>");
        JsonObject jsonObject = $this$jsonObject instanceof JsonObject ? (JsonObject)$this$jsonObject : null;
        if (jsonObject == null) {
            JsonElementKt.error($this$jsonObject, "JsonObject");
            throw new KotlinNothingValueException();
        }
        return jsonObject;
    }

    @NotNull
    public static final JsonArray getJsonArray(@NotNull JsonElement $this$jsonArray) {
        Intrinsics.checkNotNullParameter($this$jsonArray, "<this>");
        JsonArray jsonArray = $this$jsonArray instanceof JsonArray ? (JsonArray)$this$jsonArray : null;
        if (jsonArray == null) {
            JsonElementKt.error($this$jsonArray, "JsonArray");
            throw new KotlinNothingValueException();
        }
        return jsonArray;
    }

    @NotNull
    public static final JsonNull getJsonNull(@NotNull JsonElement $this$jsonNull) {
        Intrinsics.checkNotNullParameter($this$jsonNull, "<this>");
        JsonNull jsonNull = $this$jsonNull instanceof JsonNull ? (JsonNull)$this$jsonNull : null;
        if (jsonNull == null) {
            JsonElementKt.error($this$jsonNull, "JsonNull");
            throw new KotlinNothingValueException();
        }
        return jsonNull;
    }

    public static final int getInt(@NotNull JsonPrimitive $this$int) {
        Intrinsics.checkNotNullParameter($this$int, "<this>");
        return Integer.parseInt($this$int.getContent());
    }

    @Nullable
    public static final Integer getIntOrNull(@NotNull JsonPrimitive $this$intOrNull) {
        Intrinsics.checkNotNullParameter($this$intOrNull, "<this>");
        return StringsKt.toIntOrNull($this$intOrNull.getContent());
    }

    public static final long getLong(@NotNull JsonPrimitive $this$long) {
        Intrinsics.checkNotNullParameter($this$long, "<this>");
        return Long.parseLong($this$long.getContent());
    }

    @Nullable
    public static final Long getLongOrNull(@NotNull JsonPrimitive $this$longOrNull) {
        Intrinsics.checkNotNullParameter($this$longOrNull, "<this>");
        return StringsKt.toLongOrNull($this$longOrNull.getContent());
    }

    public static final double getDouble(@NotNull JsonPrimitive $this$double) {
        Intrinsics.checkNotNullParameter($this$double, "<this>");
        return Double.parseDouble($this$double.getContent());
    }

    @Nullable
    public static final Double getDoubleOrNull(@NotNull JsonPrimitive $this$doubleOrNull) {
        Intrinsics.checkNotNullParameter($this$doubleOrNull, "<this>");
        return StringsKt.toDoubleOrNull($this$doubleOrNull.getContent());
    }

    public static final float getFloat(@NotNull JsonPrimitive $this$float) {
        Intrinsics.checkNotNullParameter($this$float, "<this>");
        return Float.parseFloat($this$float.getContent());
    }

    @Nullable
    public static final Float getFloatOrNull(@NotNull JsonPrimitive $this$floatOrNull) {
        Intrinsics.checkNotNullParameter($this$floatOrNull, "<this>");
        return StringsKt.toFloatOrNull($this$floatOrNull.getContent());
    }

    public static final boolean getBoolean(@NotNull JsonPrimitive $this$boolean) {
        Intrinsics.checkNotNullParameter($this$boolean, "<this>");
        Boolean bl = StringOpsKt.toBooleanStrictOrNull($this$boolean.getContent());
        if (bl == null) {
            throw new IllegalStateException($this$boolean + " does not represent a Boolean");
        }
        return bl;
    }

    @Nullable
    public static final Boolean getBooleanOrNull(@NotNull JsonPrimitive $this$booleanOrNull) {
        Intrinsics.checkNotNullParameter($this$booleanOrNull, "<this>");
        return StringOpsKt.toBooleanStrictOrNull($this$booleanOrNull.getContent());
    }

    @Nullable
    public static final String getContentOrNull(@NotNull JsonPrimitive $this$contentOrNull) {
        Intrinsics.checkNotNullParameter($this$contentOrNull, "<this>");
        return $this$contentOrNull instanceof JsonNull ? null : $this$contentOrNull.getContent();
    }

    private static final Void error(JsonElement $this$error, String element) {
        throw new IllegalArgumentException("Element " + Reflection.getOrCreateKotlinClass($this$error.getClass()) + " is not a " + element);
    }

    @PublishedApi
    @NotNull
    public static final Void unexpectedJson(@NotNull String key, @NotNull String expected) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(expected, "expected");
        throw new IllegalArgumentException("Element " + key + " is not a " + expected);
    }
}

