/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import java.lang.annotation.Annotation;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.protobuf.ProtoIntegerType;
import kotlinx.serialization.protobuf.ProtoNumber;
import kotlinx.serialization.protobuf.ProtoPacked;
import kotlinx.serialization.protobuf.ProtoType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u000f\u001a\u001d\u0010\u0016\u001a\u00060\u0001j\u0002`\n2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\tH\u0080\b\u001a%\u0010\u0016\u001a\u00060\u0001j\u0002`\n2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000eH\u0080\b\u001a \u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u000eH\u0000\u001a\u0018\u0010\u001d\u001a\u00060\u0001j\u0002`\n*\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0004H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u001c\u0010\b\u001a\u00020\t*\u00060\u0001j\u0002`\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0018\u0010\r\u001a\u00020\u000e*\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u0010\"\u001c\u0010\u0011\u001a\u00020\u000e*\u00060\u0001j\u0002`\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\"\u001d\u0010\u0013\u001a\u00020\u0004*\u00060\u0001j\u0002`\n8\u00c0\u0002X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015*\f\b\u0000\u0010\u0016\"\u00020\u00012\u00020\u0001\u00a8\u0006\u001e"}, d2={"INTTYPEMASK", "", "PACKEDMASK", "SIZE_DELIMITED", "", "VARINT", "i32", "i64", "integerType", "Lkotlinx/serialization/protobuf/ProtoIntegerType;", "Lkotlinx/serialization/protobuf/internal/ProtoDesc;", "getIntegerType", "(J)Lkotlinx/serialization/protobuf/ProtoIntegerType;", "isPackable", "", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Lkotlinx/serialization/descriptors/SerialDescriptor;)Z", "isPacked", "(J)Z", "protoId", "getProtoId", "(J)I", "ProtoDesc", "type", "packed", "extractProtoId", "descriptor", "index", "zeroBasedDefault", "extractParameters", "kotlinx-serialization-protobuf"})
public final class HelpersKt {
    public static final int VARINT = 0;
    public static final int i64 = 1;
    public static final int SIZE_DELIMITED = 2;
    public static final int i32 = 5;
    private static final long INTTYPEMASK = 9223372028264841216L;
    private static final long PACKEDMASK = 0x100000000L;

    public static final long ProtoDesc(int protoId, @NotNull ProtoIntegerType type2, boolean packed) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        boolean $i$f$ProtoDesc = false;
        long packedBits = packed ? 0x100000000L : 0L;
        long signature2 = type2.getSignature$kotlinx_serialization_protobuf() | packedBits;
        return signature2 | (long)protoId;
    }

    public static final long ProtoDesc(int protoId, @NotNull ProtoIntegerType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        boolean $i$f$ProtoDesc = false;
        return type2.getSignature$kotlinx_serialization_protobuf() | (long)protoId;
    }

    public static final int getProtoId(long $this$protoId) {
        boolean $i$f$getProtoId = false;
        return (int)($this$protoId & Integer.MAX_VALUE);
    }

    @NotNull
    public static final ProtoIntegerType getIntegerType(long $this$integerType) {
        long l = $this$integerType & 0x7FFFFFFE00000000L;
        return l == ProtoIntegerType.DEFAULT.getSignature$kotlinx_serialization_protobuf() ? ProtoIntegerType.DEFAULT : (l == ProtoIntegerType.SIGNED.getSignature$kotlinx_serialization_protobuf() ? ProtoIntegerType.SIGNED : ProtoIntegerType.FIXED);
    }

    public static final boolean isPackable(@NotNull SerialDescriptor $this$isPackable) {
        Intrinsics.checkNotNullParameter($this$isPackable, "<this>");
        SerialKind serialKind = $this$isPackable.getKind();
        return !(Intrinsics.areEqual(serialKind, PrimitiveKind.STRING.INSTANCE) ? true : !(serialKind instanceof PrimitiveKind));
    }

    public static final boolean isPacked(long $this$isPacked) {
        return ($this$isPacked & 0x100000000L) != 0L;
    }

    public static final long extractParameters(@NotNull SerialDescriptor $this$extractParameters, int index) {
        Intrinsics.checkNotNullParameter($this$extractParameters, "<this>");
        List<Annotation> annotations2 = $this$extractParameters.getElementAnnotations(index);
        int protoId = index + 1;
        ProtoIntegerType format = ProtoIntegerType.DEFAULT;
        boolean protoPacked = false;
        int n = annotations2.size();
        for (int i = 0; i < n; ++i) {
            Annotation annotation = annotations2.get(i);
            if (annotation instanceof ProtoNumber) {
                protoId = ((ProtoNumber)annotation).number();
                continue;
            }
            if (annotation instanceof ProtoType) {
                format = ((ProtoType)annotation).type();
                continue;
            }
            if (!(annotation instanceof ProtoPacked)) continue;
            protoPacked = true;
        }
        boolean $i$f$ProtoDesc = false;
        long packedBits$iv = protoPacked ? 0x100000000L : 0L;
        long signature$iv = format.getSignature$kotlinx_serialization_protobuf() | packedBits$iv;
        return signature$iv | (long)protoId;
    }

    public static final int extractProtoId(@NotNull SerialDescriptor descriptor2, int index, boolean zeroBasedDefault) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        List<Annotation> annotations2 = descriptor2.getElementAnnotations(index);
        int n = annotations2.size();
        for (int i = 0; i < n; ++i) {
            Annotation annotation = annotations2.get(i);
            if (!(annotation instanceof ProtoNumber)) continue;
            return ((ProtoNumber)annotation).number();
        }
        return zeroBasedDefault ? index : index + 1;
    }
}

