/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.ctl.loader;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.archguard.meta.Slot;
import org.archguard.scanner.core.AnalyserSpec;
import org.archguard.scanner.core.context.Context;
import org.archguard.scanner.core.context.SlotHub;
import org.archguard.scanner.ctl.loader.AnalyserLoader;
import org.archguard.scanner.ctl.loader.SourceCodeSlot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J(\u0010\u0012\u001a\f\u0012\u0004\u0012\u00020\u00110\u0013j\u0002`\u00142\u0006\u0010\u0015\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0002J\u001e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0002J\"\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\r2\u0010\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u00110\u0013j\u0002`\u0014H\u0002J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001a\u001a\u00020\fH\u0002J(\u0010\u001b\u001a\u00020\u000f2\u0010\u0010\u0018\u001a\f\u0012\u0004\u0012\u00020\u00110\u0013j\u0002`\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0013H\u0002J\u0018\u0010\u001c\u001a\u00020\u000f2\u0010\u0010\u001d\u001a\f\u0012\b\u0012\u00060\u001ej\u0002`\u001f0\u0013J\u001c\u0010 \u001a\u00020\u000f2\n\u0010!\u001a\u00060\u001ej\u0002`\u001f2\u0006\u0010\"\u001a\u00020#H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/archguard/scanner/ctl/loader/SlotHubImpl;", "Lorg/archguard/scanner/core/context/SlotHub;", "context", "Lorg/archguard/scanner/core/context/Context;", "(Lorg/archguard/scanner/core/context/Context;)V", "getContext", "()Lorg/archguard/scanner/core/context/Context;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "slotInstanceByType", "", "", "Lorg/archguard/scanner/ctl/loader/SourceCodeSlot;", "consumer", "", "data", "", "execute", "", "Lorg/archguard/meta/OutputType;", "slot", "executeWithData", "handleForOfficialSlot", "output", "lookupSlot", "outputType", "maybeOutputCanConsume", "register", "specs", "Lorg/archguard/scanner/core/AnalyserSpec;", "Lorg/archguard/scanner/core/SlotSpec;", "registerSlotBySpec", "spec", "instance", "Lorg/archguard/meta/Slot;", "scanner_cli"})
public final class SlotHubImpl
implements SlotHub {
    @NotNull
    private final Context context;
    @NotNull
    private final Map<String, SourceCodeSlot> slotInstanceByType;
    private final Logger logger;

    public SlotHubImpl(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.slotInstanceByType = new LinkedHashMap();
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final void register(@NotNull List<AnalyserSpec> specs) {
        Intrinsics.checkNotNullParameter(specs, (String)"specs");
        Iterable $this$forEach$iv = specs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnalyserSpec it = (AnalyserSpec)element$iv;
            boolean bl = false;
            try {
                Slot slotInstance = AnalyserLoader.INSTANCE.loadSlot(it);
                this.registerSlotBySpec(it, slotInstance);
            }
            catch (Exception e) {
                this.logger.warn(String.valueOf(e.getMessage()));
            }
        }
    }

    private final void registerSlotBySpec(AnalyserSpec spec, Slot instance) {
        String coin = (String)instance.ticket().get(0);
        this.logger.info("register slot: " + spec.getIdentifier());
        this.slotInstanceByType.put(coin, new SourceCodeSlot(spec, instance));
    }

    private final SourceCodeSlot lookupSlot(String outputType) {
        return this.slotInstanceByType.get(outputType);
    }

    public final void consumer(@Nullable Object data) {
        if (data == null) {
            return;
        }
        if (!(data instanceof List)) {
            return;
        }
        List items = (List)data;
        if (items.isEmpty()) {
            return;
        }
        String outputType = items.get(0).getClass().getName();
        this.logger.info("found output type: " + outputType);
        Intrinsics.checkNotNullExpressionValue((Object)outputType, (String)"outputType");
        SourceCodeSlot sourceCodeSlot = this.lookupSlot(outputType);
        if (sourceCodeSlot == null) {
            return;
        }
        SourceCodeSlot slot = sourceCodeSlot;
        this.executeWithData(slot, items);
    }

    private final void executeWithData(SourceCodeSlot slot, List<? extends Object> data) {
        List<Object> output = this.execute(slot, data);
        this.maybeOutputCanConsume(output, data);
        this.handleForOfficialSlot(slot, output);
    }

    private final List<Object> execute(SourceCodeSlot slot, List<? extends Object> data) {
        this.logger.info("try plug slot for: " + slot.getClz());
        slot.getClz().prepare(CollectionsKt.emptyList());
        List output = slot.getClz().process(data);
        this.logger.info("done plug slot for: " + slot.getClz());
        return output;
    }

    private final void handleForOfficialSlot(SourceCodeSlot slot, List<? extends Object> output) {
        if (Intrinsics.areEqual((Object)slot.getDefine().getSlotType(), (Object)"rule")) {
            this.context.getClient().saveRuleIssues(output);
        }
    }

    private final void maybeOutputCanConsume(List<? extends Object> output, List<? extends Object> data) {
        if (output.isEmpty()) {
            return;
        }
        boolean isSameType = Intrinsics.areEqual((Object)output.get(0).getClass().getName(), (Object)data.get(0).getClass().getName());
        if (isSameType) {
            return;
        }
        this.consumer(output);
    }
}

