/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.ctl.rule;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.archguard.scanner.core.AnalyserSpec;
import org.archguard.scanner.ctl.impl.OfficialAnalyserSpecs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/archguard/scanner/ctl/rule/RuleSlot;", "", "()V", "fromName", "Lorg/archguard/scanner/core/AnalyserSpec;", "name", "", "scanner_cli"})
public final class RuleSlot {
    @NotNull
    public static final RuleSlot INSTANCE = new RuleSlot();

    private RuleSlot() {
    }

    @Nullable
    public final AnalyserSpec fromName(@NotNull String name) {
        AnalyserSpec analyserSpec;
        Intrinsics.checkNotNullParameter(name, "name");
        String url = OfficialAnalyserSpecs.Companion.host();
        String version = OfficialAnalyserSpecs.RULE.version();
        switch (name) {
            case "webapi": {
                analyserSpec = new AnalyserSpec("rule-webapi", url, version, "rule-" + name + '-' + OfficialAnalyserSpecs.RULE.version() + "-all.jar", "org.archguard.linter.rule.webapi.WebApiRuleSlot", "rule");
                break;
            }
            case "test": {
                analyserSpec = new AnalyserSpec("rule-" + name, url, version, "rule-" + name + '-' + OfficialAnalyserSpecs.RULE.version() + "-all.jar", "org.archguard.linter.rule.testcode.TestSmellRuleSlot", "rule");
                break;
            }
            case "sql": {
                analyserSpec = new AnalyserSpec("rule-" + name, url, version, "rule-" + name + '-' + OfficialAnalyserSpecs.RULE.version() + "-all.jar", "org.archguard.linter.rule.sql.DatamapRuleSlot", "rule");
                break;
            }
            default: {
                analyserSpec = null;
            }
        }
        return analyserSpec;
    }
}

