/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.SaxEventInterpretationContext;
import ch.qos.logback.core.model.Model;
import org.xml.sax.Attributes;

public abstract class BaseModelAction
extends Action {
    Model parentModel;
    Model currentModel;
    boolean inError = false;

    @Override
    public void begin(SaxEventInterpretationContext intercon, String name, Attributes attributes) throws ActionException {
        this.parentModel = null;
        this.inError = false;
        if (!this.validPreconditions(intercon, name, attributes)) {
            this.inError = true;
            return;
        }
        this.currentModel = this.buildCurrentModel(intercon, name, attributes);
        this.currentModel.setTag(name);
        if (!intercon.isModelStackEmpty()) {
            this.parentModel = intercon.peekModel();
        }
        int lineNumber = BaseModelAction.getLineNumber(intercon);
        this.currentModel.setLineNumber(lineNumber);
        intercon.pushModel(this.currentModel);
    }

    protected abstract Model buildCurrentModel(SaxEventInterpretationContext var1, String var2, Attributes var3);

    protected boolean validPreconditions(SaxEventInterpretationContext intercon, String name, Attributes attributes) {
        return true;
    }

    @Override
    public void body(SaxEventInterpretationContext ec, String body) {
        this.currentModel.addText(body);
    }

    @Override
    public void end(SaxEventInterpretationContext interpretationContext, String name) throws ActionException {
        if (this.inError) {
            return;
        }
        Model m = interpretationContext.peekModel();
        if (m != this.currentModel) {
            this.addWarn("The object at the of the stack is not the model [" + this.currentModel.idString() + "] pushed earlier.");
            this.addWarn("This is wholly unexpected.");
        }
        if (this.parentModel != null) {
            this.parentModel.addSubModel(this.currentModel);
            interpretationContext.popModel();
        }
    }
}

