/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.ctl.client;

import chapi.domain.core.CodeDataStruct;
import java.io.File;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.protobuf.ProtoBuf;
import org.archguard.rule.core.Issue;
import org.archguard.scanner.core.client.ArchGuardClient;
import org.archguard.scanner.core.diffchanges.ChangedCall;
import org.archguard.scanner.core.git.GitLogs;
import org.archguard.scanner.core.sca.CompositionDependency;
import org.archguard.scanner.core.sourcecode.CodeDatabaseRelation;
import org.archguard.scanner.core.sourcecode.ContainerService;
import org.archguard.scanner.ctl.client.ArchGuardProtobufClient;
import org.archguard.scanner.ctl.command.ScannerCommand;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J\u0019\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0082\bJ\u0019\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0082\bJ\u0016\u0010\u001b\u001a\u00020\u00162\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J\u0016\u0010\u001f\u001a\u00020\u00162\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001dH\u0016J\u0016\u0010\"\u001a\u00020\u00162\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001dH\u0016J\u0016\u0010%\u001a\u00020\u00162\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001dH\u0016J\u0016\u0010(\u001a\u00020\u00162\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u001dH\u0016J\u0016\u0010+\u001a\u00020\u00162\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u001dH\u0016J\u0016\u0010.\u001a\u00020\u00162\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u001dH\u0016R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/archguard/scanner/ctl/client/ArchGuardProtobufClient;", "Lorg/archguard/scanner/core/client/ArchGuardClient;", "language", "", "serverUrl", "systemId", "path", "command", "Lorg/archguard/scanner/ctl/command/ScannerCommand;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/archguard/scanner/ctl/command/ScannerCommand;)V", "client", "Ljava/net/http/HttpClient;", "getClient", "()Ljava/net/http/HttpClient;", "client$delegate", "Lkotlin/Lazy;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "buildUrl", "topic", "process", "", "uri", "Ljava/net/URI;", "body", "", "saveApi", "apis", "", "Lorg/archguard/scanner/core/sourcecode/ContainerService;", "saveDataStructure", "codes", "Lchapi/domain/core/CodeDataStruct;", "saveDependencies", "dependencies", "Lorg/archguard/scanner/core/sca/CompositionDependency;", "saveDiffs", "calls", "Lorg/archguard/scanner/core/diffchanges/ChangedCall;", "saveGitLogs", "gitLogs", "Lorg/archguard/scanner/core/git/GitLogs;", "saveRelation", "records", "Lorg/archguard/scanner/core/sourcecode/CodeDatabaseRelation;", "saveRuleIssues", "issues", "Lorg/archguard/rule/core/Issue;", "scanner_cli"})
public class ArchGuardProtobufClient
implements ArchGuardClient {
    @NotNull
    private final String language;
    @NotNull
    private final String serverUrl;
    @NotNull
    private final String systemId;
    @NotNull
    private final String path;
    @NotNull
    private final ScannerCommand command;
    private final Logger logger;
    @NotNull
    private final Lazy client$delegate;

    public ArchGuardProtobufClient(@NotNull String language, @NotNull String serverUrl, @NotNull String systemId, @NotNull String path, @NotNull ScannerCommand command) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.language = language;
        this.serverUrl = serverUrl;
        this.systemId = systemId;
        this.path = path;
        this.command = command;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.client$delegate = LazyKt.lazy((Function0)client.2.INSTANCE);
    }

    private final HttpClient getClient() {
        Lazy lazy = this.client$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-client>(...)");
        return (HttpClient)object;
    }

    private final String buildUrl(String topic) {
        return this.serverUrl + "/api/scanner/" + this.systemId + "/reporting/" + topic + "?language=" + this.language + "&path=" + this.path;
    }

    private final void process(URI uri, byte[] body) {
        boolean $i$f$process = false;
        HttpRequest request = HttpRequest.newBuilder(uri).header("Content-Type", "application/x-protobuf").POST(HttpRequest.BodyPublishers.ofByteArray(body)).build();
        this.logger.info(request.toString());
        this.logger.info(request.headers().toString());
        HttpResponse<String> response = this.getClient().send(request, HttpResponse.BodyHandlers.ofString());
        this.logger.info(StringsKt.trimIndent((String)("\n                response status: " + response.statusCode() + "\n                response body: " + response.body() + "\n            ")));
    }

    /*
     * WARNING - void declaration
     */
    private final void process(String topic, byte[] body) {
        void this_$iv;
        boolean $i$f$process = false;
        this.logger.info("process topic: " + topic);
        FilesKt.writeBytes((File)new File(topic + ".pb"), (byte[])body);
        ArchGuardProtobufClient archGuardProtobufClient = this;
        URI uri$iv = new URI(this.buildUrl(topic));
        boolean $i$f$process2 = false;
        HttpRequest request$iv = HttpRequest.newBuilder(uri$iv).header("Content-Type", "application/x-protobuf").POST(HttpRequest.BodyPublishers.ofByteArray(body)).build();
        this_$iv.logger.info(request$iv.toString());
        this_$iv.logger.info(request$iv.headers().toString());
        HttpResponse<String> response$iv = super.getClient().send(request$iv, HttpResponse.BodyHandlers.ofString());
        this_$iv.logger.info(StringsKt.trimIndent((String)("\n                response status: " + response$iv.statusCode() + "\n                response body: " + response$iv.body() + "\n            ")));
    }

    /*
     * WARNING - void declaration
     */
    public void saveDataStructure(@NotNull List<? extends CodeDataStruct> codes) {
        void this_$iv$iv;
        void body$iv;
        void topic$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(codes, (String)"codes");
        ArchGuardProtobufClient archGuardProtobufClient = this;
        String string = "class-items";
        Object $this$encodeToByteArray$iv = (BinaryFormat)ProtoBuf.Default;
        boolean $i$f$encodeToByteArray = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToByteArray$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(CodeDataStruct.class))));
        boolean $i$f$cast = false;
        $this$encodeToByteArray$iv = $this$encodeToByteArray$iv.encodeToByteArray((SerializationStrategy)$this$cast$iv$iv$iv, codes);
        boolean $i$f$process = false;
        this_$iv.logger.info("process topic: " + (String)topic$iv);
        FilesKt.writeBytes((File)new File((String)topic$iv + ".pb"), (byte[])body$iv);
        $this$serializer$iv$iv = this_$iv;
        URI uri$iv$iv = new URI(super.buildUrl((String)topic$iv));
        boolean $i$f$process2 = false;
        HttpRequest request$iv$iv = HttpRequest.newBuilder(uri$iv$iv).header("Content-Type", "application/x-protobuf").POST(HttpRequest.BodyPublishers.ofByteArray((byte[])body$iv)).build();
        this_$iv$iv.logger.info(request$iv$iv.toString());
        this_$iv$iv.logger.info(request$iv$iv.headers().toString());
        HttpResponse<String> response$iv$iv = super.getClient().send(request$iv$iv, HttpResponse.BodyHandlers.ofString());
        this_$iv$iv.logger.info(StringsKt.trimIndent((String)("\n                response status: " + response$iv$iv.statusCode() + "\n                response body: " + response$iv$iv.body() + "\n            ")));
    }

    /*
     * WARNING - void declaration
     */
    public void saveApi(@NotNull List<ContainerService> apis) {
        void this_$iv$iv;
        void body$iv;
        void topic$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(apis, (String)"apis");
        ArchGuardProtobufClient archGuardProtobufClient = this;
        String string = "container-services";
        Object $this$encodeToByteArray$iv = (BinaryFormat)ProtoBuf.Default;
        boolean $i$f$encodeToByteArray = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToByteArray$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(ContainerService.class))));
        boolean $i$f$cast = false;
        $this$encodeToByteArray$iv = $this$encodeToByteArray$iv.encodeToByteArray((SerializationStrategy)$this$cast$iv$iv$iv, apis);
        boolean $i$f$process = false;
        this_$iv.logger.info("process topic: " + (String)topic$iv);
        FilesKt.writeBytes((File)new File((String)topic$iv + ".pb"), (byte[])body$iv);
        $this$serializer$iv$iv = this_$iv;
        URI uri$iv$iv = new URI(super.buildUrl((String)topic$iv));
        boolean $i$f$process2 = false;
        HttpRequest request$iv$iv = HttpRequest.newBuilder(uri$iv$iv).header("Content-Type", "application/x-protobuf").POST(HttpRequest.BodyPublishers.ofByteArray((byte[])body$iv)).build();
        this_$iv$iv.logger.info(request$iv$iv.toString());
        this_$iv$iv.logger.info(request$iv$iv.headers().toString());
        HttpResponse<String> response$iv$iv = super.getClient().send(request$iv$iv, HttpResponse.BodyHandlers.ofString());
        this_$iv$iv.logger.info(StringsKt.trimIndent((String)("\n                response status: " + response$iv$iv.statusCode() + "\n                response body: " + response$iv$iv.body() + "\n            ")));
    }

    /*
     * WARNING - void declaration
     */
    public void saveRelation(@NotNull List<CodeDatabaseRelation> records) {
        void this_$iv$iv;
        void body$iv;
        void topic$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(records, (String)"records");
        ArchGuardProtobufClient archGuardProtobufClient = this;
        String string = "datamap-relations";
        Object $this$encodeToByteArray$iv = (BinaryFormat)ProtoBuf.Default;
        boolean $i$f$encodeToByteArray = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToByteArray$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(CodeDatabaseRelation.class))));
        boolean $i$f$cast = false;
        $this$encodeToByteArray$iv = $this$encodeToByteArray$iv.encodeToByteArray((SerializationStrategy)$this$cast$iv$iv$iv, records);
        boolean $i$f$process = false;
        this_$iv.logger.info("process topic: " + (String)topic$iv);
        FilesKt.writeBytes((File)new File((String)topic$iv + ".pb"), (byte[])body$iv);
        $this$serializer$iv$iv = this_$iv;
        URI uri$iv$iv = new URI(super.buildUrl((String)topic$iv));
        boolean $i$f$process2 = false;
        HttpRequest request$iv$iv = HttpRequest.newBuilder(uri$iv$iv).header("Content-Type", "application/x-protobuf").POST(HttpRequest.BodyPublishers.ofByteArray((byte[])body$iv)).build();
        this_$iv$iv.logger.info(request$iv$iv.toString());
        this_$iv$iv.logger.info(request$iv$iv.headers().toString());
        HttpResponse<String> response$iv$iv = super.getClient().send(request$iv$iv, HttpResponse.BodyHandlers.ofString());
        this_$iv$iv.logger.info(StringsKt.trimIndent((String)("\n                response status: " + response$iv$iv.statusCode() + "\n                response body: " + response$iv$iv.body() + "\n            ")));
    }

    /*
     * WARNING - void declaration
     */
    public void saveGitLogs(@NotNull List<GitLogs> gitLogs) {
        void this_$iv$iv;
        void body$iv;
        void topic$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(gitLogs, (String)"gitLogs");
        ArchGuardProtobufClient archGuardProtobufClient = this;
        String string = "git-logs";
        Object $this$encodeToByteArray$iv = (BinaryFormat)ProtoBuf.Default;
        boolean $i$f$encodeToByteArray = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToByteArray$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(GitLogs.class))));
        boolean $i$f$cast = false;
        $this$encodeToByteArray$iv = $this$encodeToByteArray$iv.encodeToByteArray((SerializationStrategy)$this$cast$iv$iv$iv, gitLogs);
        boolean $i$f$process = false;
        this_$iv.logger.info("process topic: " + (String)topic$iv);
        FilesKt.writeBytes((File)new File((String)topic$iv + ".pb"), (byte[])body$iv);
        $this$serializer$iv$iv = this_$iv;
        URI uri$iv$iv = new URI(super.buildUrl((String)topic$iv));
        boolean $i$f$process2 = false;
        HttpRequest request$iv$iv = HttpRequest.newBuilder(uri$iv$iv).header("Content-Type", "application/x-protobuf").POST(HttpRequest.BodyPublishers.ofByteArray((byte[])body$iv)).build();
        this_$iv$iv.logger.info(request$iv$iv.toString());
        this_$iv$iv.logger.info(request$iv$iv.headers().toString());
        HttpResponse<String> response$iv$iv = super.getClient().send(request$iv$iv, HttpResponse.BodyHandlers.ofString());
        this_$iv$iv.logger.info(StringsKt.trimIndent((String)("\n                response status: " + response$iv$iv.statusCode() + "\n                response body: " + response$iv$iv.body() + "\n            ")));
    }

    /*
     * WARNING - void declaration
     */
    public void saveDiffs(@NotNull List<ChangedCall> calls) {
        void this_$iv;
        void body$iv;
        void uri$iv;
        Intrinsics.checkNotNullParameter(calls, (String)"calls");
        String url = this.buildUrl("diff-changes") + "&since=" + this.command.getSince() + "&until=" + this.command.getUntil();
        ArchGuardProtobufClient archGuardProtobufClient = this;
        URI uRI = new URI(url);
        Object $this$encodeToByteArray$iv = (BinaryFormat)ProtoBuf.Default;
        boolean $i$f$encodeToByteArray = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToByteArray$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(ChangedCall.class))));
        boolean $i$f$cast = false;
        $this$encodeToByteArray$iv = $this$encodeToByteArray$iv.encodeToByteArray((SerializationStrategy)$this$cast$iv$iv$iv, calls);
        boolean $i$f$process = false;
        HttpRequest request$iv = HttpRequest.newBuilder((URI)uri$iv).header("Content-Type", "application/x-protobuf").POST(HttpRequest.BodyPublishers.ofByteArray((byte[])body$iv)).build();
        this_$iv.logger.info(request$iv.toString());
        this_$iv.logger.info(request$iv.headers().toString());
        HttpResponse<String> response$iv = super.getClient().send(request$iv, HttpResponse.BodyHandlers.ofString());
        this_$iv.logger.info(StringsKt.trimIndent((String)("\n                response status: " + response$iv.statusCode() + "\n                response body: " + response$iv.body() + "\n            ")));
    }

    /*
     * WARNING - void declaration
     */
    public void saveDependencies(@NotNull List<CompositionDependency> dependencies) {
        void this_$iv$iv;
        void body$iv;
        void topic$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        ArchGuardProtobufClient archGuardProtobufClient = this;
        String string = "sca-dependencies";
        Object $this$encodeToByteArray$iv = (BinaryFormat)ProtoBuf.Default;
        boolean $i$f$encodeToByteArray = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToByteArray$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(CompositionDependency.class))));
        boolean $i$f$cast = false;
        $this$encodeToByteArray$iv = $this$encodeToByteArray$iv.encodeToByteArray((SerializationStrategy)$this$cast$iv$iv$iv, dependencies);
        boolean $i$f$process = false;
        this_$iv.logger.info("process topic: " + (String)topic$iv);
        FilesKt.writeBytes((File)new File((String)topic$iv + ".pb"), (byte[])body$iv);
        $this$serializer$iv$iv = this_$iv;
        URI uri$iv$iv = new URI(super.buildUrl((String)topic$iv));
        boolean $i$f$process2 = false;
        HttpRequest request$iv$iv = HttpRequest.newBuilder(uri$iv$iv).header("Content-Type", "application/x-protobuf").POST(HttpRequest.BodyPublishers.ofByteArray((byte[])body$iv)).build();
        this_$iv$iv.logger.info(request$iv$iv.toString());
        this_$iv$iv.logger.info(request$iv$iv.headers().toString());
        HttpResponse<String> response$iv$iv = super.getClient().send(request$iv$iv, HttpResponse.BodyHandlers.ofString());
        this_$iv$iv.logger.info(StringsKt.trimIndent((String)("\n                response status: " + response$iv$iv.statusCode() + "\n                response body: " + response$iv$iv.body() + "\n            ")));
    }

    /*
     * WARNING - void declaration
     */
    public void saveRuleIssues(@NotNull List<Issue> issues) {
        void this_$iv$iv;
        void body$iv;
        void topic$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        ArchGuardProtobufClient archGuardProtobufClient = this;
        String string = "issues";
        Object $this$encodeToByteArray$iv = (BinaryFormat)ProtoBuf.Default;
        boolean $i$f$encodeToByteArray = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToByteArray$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(Issue.class))));
        boolean $i$f$cast = false;
        $this$encodeToByteArray$iv = $this$encodeToByteArray$iv.encodeToByteArray((SerializationStrategy)$this$cast$iv$iv$iv, issues);
        boolean $i$f$process = false;
        this_$iv.logger.info("process topic: " + (String)topic$iv);
        FilesKt.writeBytes((File)new File((String)topic$iv + ".pb"), (byte[])body$iv);
        $this$serializer$iv$iv = this_$iv;
        URI uri$iv$iv = new URI(super.buildUrl((String)topic$iv));
        boolean $i$f$process2 = false;
        HttpRequest request$iv$iv = HttpRequest.newBuilder(uri$iv$iv).header("Content-Type", "application/x-protobuf").POST(HttpRequest.BodyPublishers.ofByteArray((byte[])body$iv)).build();
        this_$iv$iv.logger.info(request$iv$iv.toString());
        this_$iv$iv.logger.info(request$iv$iv.headers().toString());
        HttpResponse<String> response$iv$iv = super.getClient().send(request$iv$iv, HttpResponse.BodyHandlers.ofString());
        this_$iv$iv.logger.info(StringsKt.trimIndent((String)("\n                response status: " + response$iv$iv.statusCode() + "\n                response body: " + response$iv$iv.body() + "\n            ")));
    }
}

