/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.ctl.client;

import chapi.domain.core.CodeDataStruct;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.archguard.rule.core.Issue;
import org.archguard.scanner.core.client.ArchGuardClient;
import org.archguard.scanner.core.diffchanges.ChangedCall;
import org.archguard.scanner.core.git.GitLogs;
import org.archguard.scanner.core.sca.CompositionDependency;
import org.archguard.scanner.core.sourcecode.CodeDatabaseRelation;
import org.archguard.scanner.core.sourcecode.ContainerService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0002J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\u0016\u0010\f\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\nH\u0016J\u0016\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\nH\u0016J\u0016\u0010\u0012\u001a\u00020\b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\nH\u0016J\u0016\u0010\u0015\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\nH\u0016J\u0016\u0010\u0018\u001a\u00020\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\nH\u0016J\u0016\u0010\u001b\u001a\u00020\b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/archguard/scanner/ctl/client/ArchGuardConsoleClient;", "Lorg/archguard/scanner/core/client/ArchGuardClient;", "systemId", "", "(Ljava/lang/String;)V", "buildFileName", "topic", "saveApi", "", "apis", "", "Lorg/archguard/scanner/core/sourcecode/ContainerService;", "saveDataStructure", "codes", "Lchapi/domain/core/CodeDataStruct;", "saveDependencies", "dependencies", "Lorg/archguard/scanner/core/sca/CompositionDependency;", "saveDiffs", "calls", "Lorg/archguard/scanner/core/diffchanges/ChangedCall;", "saveGitLogs", "gitLogs", "Lorg/archguard/scanner/core/git/GitLogs;", "saveRelation", "records", "Lorg/archguard/scanner/core/sourcecode/CodeDatabaseRelation;", "saveRuleIssues", "issues", "Lorg/archguard/rule/core/Issue;", "scanner_cli"})
public class ArchGuardConsoleClient
implements ArchGuardClient {
    @NotNull
    private final String systemId;

    public ArchGuardConsoleClient(@NotNull String systemId) {
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        this.systemId = systemId;
    }

    private final String buildFileName(String topic) {
        return this.systemId + '_' + topic + ".json";
    }

    public void saveDataStructure(@NotNull List<? extends CodeDataStruct> codes) {
        Intrinsics.checkNotNullParameter(codes, (String)"codes");
        System.out.println((Object)"==============================================================");
        System.out.println((Object)"Output code data structures to console");
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(CodeDataStruct.class))));
        boolean $i$f$cast = false;
        String string = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, codes);
        System.out.println((Object)string);
    }

    public void saveApi(@NotNull List<ContainerService> apis) {
        Intrinsics.checkNotNullParameter(apis, (String)"apis");
        System.out.println((Object)"==============================================================");
        System.out.println((Object)"Output api container services to console");
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(ContainerService.class))));
        boolean $i$f$cast = false;
        String string = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, apis);
        System.out.println((Object)string);
    }

    public void saveRelation(@NotNull List<CodeDatabaseRelation> records) {
        Intrinsics.checkNotNullParameter(records, (String)"records");
        System.out.println((Object)"==============================================================");
        System.out.println((Object)"Output database relationships to console");
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(CodeDatabaseRelation.class))));
        boolean $i$f$cast = false;
        String string = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, records);
        System.out.println((Object)string);
    }

    public void saveGitLogs(@NotNull List<GitLogs> gitLogs) {
        Intrinsics.checkNotNullParameter(gitLogs, (String)"gitLogs");
        System.out.println((Object)"==============================================================");
        System.out.println((Object)"Output git logs to console");
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(GitLogs.class))));
        boolean $i$f$cast = false;
        String string = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, gitLogs);
        System.out.println((Object)string);
    }

    public void saveDiffs(@NotNull List<ChangedCall> calls) {
        Intrinsics.checkNotNullParameter(calls, (String)"calls");
        System.out.println((Object)"==============================================================");
        System.out.println((Object)"Output git diffs to console");
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(ChangedCall.class))));
        boolean $i$f$cast = false;
        String string = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, calls);
        System.out.println((Object)string);
    }

    public void saveDependencies(@NotNull List<CompositionDependency> dependencies) {
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        System.out.println((Object)"==============================================================");
        System.out.println((Object)"Output project dependencies to console");
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(CompositionDependency.class))));
        boolean $i$f$cast = false;
        String string = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, dependencies);
        System.out.println((Object)string);
    }

    public void saveRuleIssues(@NotNull List<Issue> issues) {
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        System.out.println((Object)"==============================================================");
        System.out.println((Object)"Output project dependencies to console");
        StringFormat $this$encodeToString$iv = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(Issue.class))));
        boolean $i$f$cast = false;
        String string = $this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, issues);
        System.out.println((Object)string);
    }
}

