/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.ctl.client;

import chapi.domain.core.CodeDataStruct;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.archguard.rule.core.Issue;
import org.archguard.scanner.core.client.ArchGuardClient;
import org.archguard.scanner.core.diffchanges.ChangedCall;
import org.archguard.scanner.core.git.GitLogs;
import org.archguard.scanner.core.sca.CompositionDependency;
import org.archguard.scanner.core.sourcecode.CodeDatabaseRelation;
import org.archguard.scanner.core.sourcecode.ContainerService;
import org.archguard.scanner.ctl.client.ArchGuardHttpClient;
import org.archguard.scanner.ctl.command.ScannerCommand;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0002J&\u0010\u0015\u001a\u00020\u0016\"\u0006\b\u0000\u0010\u0017\u0018\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u0002H\u0017H\u0082\b\u00a2\u0006\u0002\u0010\u001bJ&\u0010\u0015\u001a\u00020\u0016\"\u0006\b\u0000\u0010\u0017\u0018\u00012\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u0002H\u0017H\u0082\b\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0016J\u0016\u0010!\u001a\u00020\u00162\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u001fH\u0016J\u0016\u0010$\u001a\u00020\u00162\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u001fH\u0016J\u0016\u0010'\u001a\u00020\u00162\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u001fH\u0016J\u0016\u0010*\u001a\u00020\u00162\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u001fH\u0016J\u0016\u0010-\u001a\u00020\u00162\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u001fH\u0016J\u0016\u00100\u001a\u00020\u00162\f\u00101\u001a\b\u0012\u0004\u0012\u0002020\u001fH\u0016R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/archguard/scanner/ctl/client/ArchGuardHttpClient;", "Lorg/archguard/scanner/core/client/ArchGuardClient;", "language", "", "serverUrl", "systemId", "path", "command", "Lorg/archguard/scanner/ctl/command/ScannerCommand;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/archguard/scanner/ctl/command/ScannerCommand;)V", "client", "Ljava/net/http/HttpClient;", "getClient", "()Ljava/net/http/HttpClient;", "client$delegate", "Lkotlin/Lazy;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "buildUrl", "topic", "process", "", "T", "uri", "Ljava/net/URI;", "body", "(Ljava/net/URI;Ljava/lang/Object;)V", "(Ljava/lang/String;Ljava/lang/Object;)V", "saveApi", "apis", "", "Lorg/archguard/scanner/core/sourcecode/ContainerService;", "saveDataStructure", "codes", "Lchapi/domain/core/CodeDataStruct;", "saveDependencies", "dependencies", "Lorg/archguard/scanner/core/sca/CompositionDependency;", "saveDiffs", "calls", "Lorg/archguard/scanner/core/diffchanges/ChangedCall;", "saveGitLogs", "gitLogs", "Lorg/archguard/scanner/core/git/GitLogs;", "saveRelation", "records", "Lorg/archguard/scanner/core/sourcecode/CodeDatabaseRelation;", "saveRuleIssues", "issues", "Lorg/archguard/rule/core/Issue;", "scanner_cli"})
public final class ArchGuardHttpClient
implements ArchGuardClient {
    @NotNull
    private final String language;
    @NotNull
    private final String serverUrl;
    @NotNull
    private final String systemId;
    @NotNull
    private final String path;
    @NotNull
    private final ScannerCommand command;
    private final Logger logger;
    @NotNull
    private final Lazy client$delegate;

    public ArchGuardHttpClient(@NotNull String language, @NotNull String serverUrl, @NotNull String systemId, @NotNull String path2, @NotNull ScannerCommand command2) {
        Intrinsics.checkNotNullParameter(language, "language");
        Intrinsics.checkNotNullParameter(serverUrl, "serverUrl");
        Intrinsics.checkNotNullParameter(systemId, "systemId");
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(command2, "command");
        this.language = language;
        this.serverUrl = serverUrl;
        this.systemId = systemId;
        this.path = path2;
        this.command = command2;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.client$delegate = LazyKt.lazy(client.2.INSTANCE);
    }

    private final HttpClient getClient() {
        Lazy lazy = this.client$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "<get-client>(...)");
        return (HttpClient)t;
    }

    private final String buildUrl(String topic) {
        return this.serverUrl + "/api/scanner/" + this.systemId + "/reporting/" + topic + "?language=" + this.language + "&path=" + this.path;
    }

    private final /* synthetic */ <T> void process(URI uri, T body) {
        boolean $i$f$process = false;
        HttpRequest.Builder builder = HttpRequest.newBuilder(uri);
        StringFormat $this$encodeToString$iv = Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = $this$encodeToString$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        Intrinsics.reifiedOperationMarker(6, "T");
        KSerializer<Object> $this$cast$iv$iv$iv = SerializersKt.serializer($this$serializer$iv$iv, null);
        boolean $i$f$cast = false;
        HttpRequest request = builder.POST(HttpRequest.BodyPublishers.ofString($this$encodeToString$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, body))).header("Content-Type", "application/json").build();
        HttpResponse<String> response = this.getClient().send(request, HttpResponse.BodyHandlers.ofString());
        this.logger.info(StringsKt.trimIndent("\n                response status: " + response.statusCode() + "\n                response body: " + response.body() + "\n            "));
    }

    /*
     * WARNING - void declaration
     */
    private final /* synthetic */ <T> void process(String topic, T body) {
        void this_$iv;
        boolean $i$f$process = false;
        this.logger.info("process topic: " + topic);
        ArchGuardHttpClient archGuardHttpClient = this;
        URI uri$iv = new URI(this.buildUrl(topic));
        boolean $i$f$process2 = false;
        HttpRequest.Builder builder = HttpRequest.newBuilder(uri$iv);
        StringFormat $this$encodeToString$iv$iv = Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv$iv = $this$encodeToString$iv$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        Intrinsics.reifiedOperationMarker(6, "T");
        KSerializer<Object> $this$cast$iv$iv$iv$iv = SerializersKt.serializer($this$serializer$iv$iv$iv, null);
        boolean $i$f$cast = false;
        HttpRequest request$iv = builder.POST(HttpRequest.BodyPublishers.ofString($this$encodeToString$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv, body))).header("Content-Type", "application/json").build();
        HttpResponse<String> response$iv = super.getClient().send(request$iv, HttpResponse.BodyHandlers.ofString());
        this_$iv.logger.info(StringsKt.trimIndent("\n                response status: " + response$iv.statusCode() + "\n                response body: " + response$iv.body() + "\n            "));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveDataStructure(@NotNull List<? extends CodeDataStruct> codes) {
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(codes, "codes");
        ArchGuardHttpClient archGuardHttpClient = this;
        String topic$iv = "class-items";
        boolean $i$f$process = false;
        this_$iv.logger.info("process topic: " + topic$iv);
        void var5_5 = this_$iv;
        URI uri$iv$iv = new URI(super.buildUrl(topic$iv));
        boolean $i$f$process2 = false;
        StringFormat $this$encodeToString$iv$iv$iv = Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv$iv$iv = $this$encodeToString$iv$iv$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer<Object> $this$cast$iv$iv$iv$iv$iv = SerializersKt.serializer($this$serializer$iv$iv$iv$iv, Reflection.typeOf(List.class, KTypeProjection.Companion.invariant(Reflection.typeOf(CodeDataStruct.class))));
        boolean $i$f$cast = false;
        HttpRequest request$iv$iv = HttpRequest.newBuilder(uri$iv$iv).POST(HttpRequest.BodyPublishers.ofString($this$encodeToString$iv$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv$iv, codes))).header("Content-Type", "application/json").build();
        HttpResponse<String> response$iv$iv = super.getClient().send(request$iv$iv, HttpResponse.BodyHandlers.ofString());
        this_$iv$iv.logger.info(StringsKt.trimIndent("\n                response status: " + response$iv$iv.statusCode() + "\n                response body: " + response$iv$iv.body() + "\n            "));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveApi(@NotNull List<ContainerService> apis) {
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(apis, "apis");
        ArchGuardHttpClient archGuardHttpClient = this;
        String topic$iv = "container-services";
        boolean $i$f$process = false;
        this_$iv.logger.info("process topic: " + topic$iv);
        void var5_5 = this_$iv;
        URI uri$iv$iv = new URI(super.buildUrl(topic$iv));
        boolean $i$f$process2 = false;
        StringFormat $this$encodeToString$iv$iv$iv = Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv$iv$iv = $this$encodeToString$iv$iv$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer<Object> $this$cast$iv$iv$iv$iv$iv = SerializersKt.serializer($this$serializer$iv$iv$iv$iv, Reflection.typeOf(List.class, KTypeProjection.Companion.invariant(Reflection.typeOf(ContainerService.class))));
        boolean $i$f$cast = false;
        HttpRequest request$iv$iv = HttpRequest.newBuilder(uri$iv$iv).POST(HttpRequest.BodyPublishers.ofString($this$encodeToString$iv$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv$iv, apis))).header("Content-Type", "application/json").build();
        HttpResponse<String> response$iv$iv = super.getClient().send(request$iv$iv, HttpResponse.BodyHandlers.ofString());
        this_$iv$iv.logger.info(StringsKt.trimIndent("\n                response status: " + response$iv$iv.statusCode() + "\n                response body: " + response$iv$iv.body() + "\n            "));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveRelation(@NotNull List<CodeDatabaseRelation> records) {
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(records, "records");
        ArchGuardHttpClient archGuardHttpClient = this;
        String topic$iv = "datamap-relations";
        boolean $i$f$process = false;
        this_$iv.logger.info("process topic: " + topic$iv);
        void var5_5 = this_$iv;
        URI uri$iv$iv = new URI(super.buildUrl(topic$iv));
        boolean $i$f$process2 = false;
        StringFormat $this$encodeToString$iv$iv$iv = Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv$iv$iv = $this$encodeToString$iv$iv$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer<Object> $this$cast$iv$iv$iv$iv$iv = SerializersKt.serializer($this$serializer$iv$iv$iv$iv, Reflection.typeOf(List.class, KTypeProjection.Companion.invariant(Reflection.typeOf(CodeDatabaseRelation.class))));
        boolean $i$f$cast = false;
        HttpRequest request$iv$iv = HttpRequest.newBuilder(uri$iv$iv).POST(HttpRequest.BodyPublishers.ofString($this$encodeToString$iv$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv$iv, records))).header("Content-Type", "application/json").build();
        HttpResponse<String> response$iv$iv = super.getClient().send(request$iv$iv, HttpResponse.BodyHandlers.ofString());
        this_$iv$iv.logger.info(StringsKt.trimIndent("\n                response status: " + response$iv$iv.statusCode() + "\n                response body: " + response$iv$iv.body() + "\n            "));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveGitLogs(@NotNull List<GitLogs> gitLogs) {
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(gitLogs, "gitLogs");
        ArchGuardHttpClient archGuardHttpClient = this;
        String topic$iv = "git-logs";
        boolean $i$f$process = false;
        this_$iv.logger.info("process topic: " + topic$iv);
        void var5_5 = this_$iv;
        URI uri$iv$iv = new URI(super.buildUrl(topic$iv));
        boolean $i$f$process2 = false;
        StringFormat $this$encodeToString$iv$iv$iv = Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv$iv$iv = $this$encodeToString$iv$iv$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer<Object> $this$cast$iv$iv$iv$iv$iv = SerializersKt.serializer($this$serializer$iv$iv$iv$iv, Reflection.typeOf(List.class, KTypeProjection.Companion.invariant(Reflection.typeOf(GitLogs.class))));
        boolean $i$f$cast = false;
        HttpRequest request$iv$iv = HttpRequest.newBuilder(uri$iv$iv).POST(HttpRequest.BodyPublishers.ofString($this$encodeToString$iv$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv$iv, gitLogs))).header("Content-Type", "application/json").build();
        HttpResponse<String> response$iv$iv = super.getClient().send(request$iv$iv, HttpResponse.BodyHandlers.ofString());
        this_$iv$iv.logger.info(StringsKt.trimIndent("\n                response status: " + response$iv$iv.statusCode() + "\n                response body: " + response$iv$iv.body() + "\n            "));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveDiffs(@NotNull List<ChangedCall> calls) {
        void this_$iv;
        Intrinsics.checkNotNullParameter(calls, "calls");
        String url = this.buildUrl("diff-changes") + "&since=" + this.command.getSince() + "&until=" + this.command.getUntil();
        ArchGuardHttpClient archGuardHttpClient = this;
        URI uri$iv = new URI(url);
        boolean $i$f$process = false;
        StringFormat $this$encodeToString$iv$iv = Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv$iv = $this$encodeToString$iv$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer<Object> $this$cast$iv$iv$iv$iv = SerializersKt.serializer($this$serializer$iv$iv$iv, Reflection.typeOf(List.class, KTypeProjection.Companion.invariant(Reflection.typeOf(ChangedCall.class))));
        boolean $i$f$cast = false;
        HttpRequest request$iv = HttpRequest.newBuilder(uri$iv).POST(HttpRequest.BodyPublishers.ofString($this$encodeToString$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv, calls))).header("Content-Type", "application/json").build();
        HttpResponse<String> response$iv = super.getClient().send(request$iv, HttpResponse.BodyHandlers.ofString());
        this_$iv.logger.info(StringsKt.trimIndent("\n                response status: " + response$iv.statusCode() + "\n                response body: " + response$iv.body() + "\n            "));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveDependencies(@NotNull List<CompositionDependency> dependencies) {
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(dependencies, "dependencies");
        ArchGuardHttpClient archGuardHttpClient = this;
        String topic$iv = "sca-dependencies";
        boolean $i$f$process = false;
        this_$iv.logger.info("process topic: " + topic$iv);
        void var5_5 = this_$iv;
        URI uri$iv$iv = new URI(super.buildUrl(topic$iv));
        boolean $i$f$process2 = false;
        StringFormat $this$encodeToString$iv$iv$iv = Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv$iv$iv = $this$encodeToString$iv$iv$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer<Object> $this$cast$iv$iv$iv$iv$iv = SerializersKt.serializer($this$serializer$iv$iv$iv$iv, Reflection.typeOf(List.class, KTypeProjection.Companion.invariant(Reflection.typeOf(CompositionDependency.class))));
        boolean $i$f$cast = false;
        HttpRequest request$iv$iv = HttpRequest.newBuilder(uri$iv$iv).POST(HttpRequest.BodyPublishers.ofString($this$encodeToString$iv$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv$iv, dependencies))).header("Content-Type", "application/json").build();
        HttpResponse<String> response$iv$iv = super.getClient().send(request$iv$iv, HttpResponse.BodyHandlers.ofString());
        this_$iv$iv.logger.info(StringsKt.trimIndent("\n                response status: " + response$iv$iv.statusCode() + "\n                response body: " + response$iv$iv.body() + "\n            "));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void saveRuleIssues(@NotNull List<Issue> issues) {
        void this_$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter(issues, "issues");
        ArchGuardHttpClient archGuardHttpClient = this;
        String topic$iv = "issues";
        boolean $i$f$process = false;
        this_$iv.logger.info("process topic: " + topic$iv);
        void var5_5 = this_$iv;
        URI uri$iv$iv = new URI(super.buildUrl(topic$iv));
        boolean $i$f$process2 = false;
        StringFormat $this$encodeToString$iv$iv$iv = Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv$iv$iv = $this$encodeToString$iv$iv$iv.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer<Object> $this$cast$iv$iv$iv$iv$iv = SerializersKt.serializer($this$serializer$iv$iv$iv$iv, Reflection.typeOf(List.class, KTypeProjection.Companion.invariant(Reflection.typeOf(Issue.class))));
        boolean $i$f$cast = false;
        HttpRequest request$iv$iv = HttpRequest.newBuilder(uri$iv$iv).POST(HttpRequest.BodyPublishers.ofString($this$encodeToString$iv$iv$iv.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv$iv$iv, issues))).header("Content-Type", "application/json").build();
        HttpResponse<String> response$iv$iv = super.getClient().send(request$iv$iv, HttpResponse.BodyHandlers.ofString());
        this_$iv$iv.logger.info(StringsKt.trimIndent("\n                response status: " + response$iv$iv.statusCode() + "\n                response body: " + response$iv$iv.body() + "\n            "));
    }
}

