/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.core.diffchanges;

import chapi.domain.core.CodeAnnotation;
import chapi.domain.core.CodeCall;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.archguard.scanner.core.diffchanges.NodeRelation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u000f2\b\b\u0002\u0010\u0016\u001a\u00020\rH\u0016J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012H\u0016J\u0016\u0010\u001b\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0012H\u0016J \u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0018H\u0016J\u0010\u0010\"\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001aH\u0002J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u000f0\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\b\u00a8\u0006%"}, d2={"Lorg/archguard/scanner/core/diffchanges/NodeRelationBuilder;", "", "()V", "functionMap", "", "", "", "getFunctionMap", "()Ljava/util/Map;", "injectionMap", "getInjectionMap", "lastReverseCallChild", "loopCount", "", "reverseCallMap", "", "getReverseCallMap", "calculateReverseCalls", "", "Lorg/archguard/scanner/core/diffchanges/NodeRelation;", "sourceFunctionName", "nodeRelations", "loopDepth", "fillFunctionMap", "", "dataStructs", "Lchapi/domain/core/CodeDataStruct;", "fillReverseCallMap", "insertToReverse", "node", "nodeName", "it", "Lchapi/domain/core/CodeFunction;", "resetCount", "updateDependencyInjection", "updateInjectionNode", "canonicalName", "scanner_core"})
@SourceDebugExtension(value={"SMAP\nNodeRelationBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeRelationBuilder.kt\norg/archguard/scanner/core/diffchanges/NodeRelationBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1855#2,2:142\n1855#2:144\n1855#2,2:145\n1856#2:147\n1855#2:148\n1855#2,2:149\n1856#2:151\n1855#2,2:152\n1#3:154\n*S KotlinDebug\n*F\n+ 1 NodeRelationBuilder.kt\norg/archguard/scanner/core/diffchanges/NodeRelationBuilder\n*L\n50#1:142,2\n90#1:144\n92#1:145,2\n90#1:147\n99#1:148\n102#1:149,2\n99#1:151\n114#1:152,2\n*E\n"})
public class NodeRelationBuilder {
    @NotNull
    private final Map<String, Boolean> functionMap = new LinkedHashMap();
    @NotNull
    private final Map<String, List<String>> reverseCallMap = new LinkedHashMap();
    @NotNull
    private final Map<String, String> injectionMap = new LinkedHashMap();
    private int loopCount;
    @NotNull
    private String lastReverseCallChild = "";

    @NotNull
    public Map<String, Boolean> getFunctionMap() {
        return this.functionMap;
    }

    @NotNull
    public Map<String, List<String>> getReverseCallMap() {
        return this.reverseCallMap;
    }

    @NotNull
    public Map<String, String> getInjectionMap() {
        return this.injectionMap;
    }

    public void resetCount() {
        this.loopCount = 0;
    }

    @Nullable
    public List<NodeRelation> calculateReverseCalls(@NotNull String sourceFunctionName, @NotNull List<NodeRelation> nodeRelations, int loopDepth) {
        block5: {
            List<String> calls;
            Intrinsics.checkNotNullParameter((Object)sourceFunctionName, (String)"sourceFunctionName");
            Intrinsics.checkNotNullParameter(nodeRelations, (String)"nodeRelations");
            if (this.loopCount > loopDepth) {
                return null;
            }
            int n = this.loopCount;
            this.loopCount = n + 1;
            String maybeNewFuncName = this.updateInjectionNode(sourceFunctionName);
            List<String> list = calls = this.getReverseCallMap().get(maybeNewFuncName);
            if (list == null) break block5;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String sourceName;
                String child = (String)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)child, (Object)this.lastReverseCallChild)) {
                    return null;
                }
                if (this.getReverseCallMap().get(child) != null) {
                    this.lastReverseCallChild = child;
                    sourceName = this.updateInjectionNode(child);
                    List<NodeRelation> optRelations = this.calculateReverseCalls(sourceName, nodeRelations, loopDepth);
                    if (optRelations != null) {
                        CollectionsKt.addAll((Collection)nodeRelations, (Iterable)optRelations);
                    }
                }
                if (Intrinsics.areEqual((Object)child, (Object)maybeNewFuncName)) continue;
                sourceName = this.updateInjectionNode(child);
                String targetName = this.updateInjectionNode(maybeNewFuncName);
                ((Collection)nodeRelations).add(new NodeRelation(sourceName, targetName));
            }
        }
        return null;
    }

    public static /* synthetic */ List calculateReverseCalls$default(NodeRelationBuilder nodeRelationBuilder, String string, List list, int n, int n2, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: calculateReverseCalls");
        }
        if ((n2 & 4) != 0) {
            n = 7;
        }
        return nodeRelationBuilder.calculateReverseCalls(string, list, n);
    }

    private final String updateInjectionNode(String canonicalName) {
        String functionName = StringsKt.substringAfterLast$default((String)canonicalName, (String)".", null, (int)2, null);
        String nodeName = StringsKt.substringBeforeLast$default((String)canonicalName, (String)".", null, (int)2, null);
        String injectionName = this.getInjectionMap().get(nodeName);
        if (injectionName != null) {
            return injectionName + '.' + functionName;
        }
        return canonicalName;
    }

    public void fillFunctionMap(@NotNull List<CodeDataStruct> dataStructs) {
        Intrinsics.checkNotNullParameter(dataStructs, (String)"dataStructs");
        Iterable $this$forEach$iv = dataStructs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeDataStruct node = (CodeDataStruct)element$iv;
            boolean bl = false;
            this.updateDependencyInjection(node);
            Iterable $this$forEach$iv2 = node.getFunctions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                CodeFunction it = (CodeFunction)element$iv2;
                boolean bl2 = false;
                this.getFunctionMap().put(node.getPackage() + '.' + node.getNodeName() + '.' + it.getName(), true);
            }
        }
    }

    public void fillReverseCallMap(@NotNull List<CodeDataStruct> dataStructs) {
        Intrinsics.checkNotNullParameter(dataStructs, (String)"dataStructs");
        Iterable $this$forEach$iv = dataStructs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeDataStruct node = (CodeDataStruct)element$iv;
            boolean bl = false;
            this.updateDependencyInjection(node);
            Iterable $this$forEach$iv2 = node.getFunctions();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                CodeFunction it = (CodeFunction)element$iv2;
                boolean bl2 = false;
                this.insertToReverse(node, node.getNodeName(), it);
            }
        }
    }

    private final void insertToReverse(CodeDataStruct node, String nodeName, CodeFunction it) {
        String caller = node.getPackage() + '.' + nodeName + '.' + it.getName();
        Iterable $this$forEach$iv = it.getFunctionCalls();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeCall codeCall = (CodeCall)element$iv;
            boolean bl = false;
            String callee = codeCall.buildFullMethodName();
            if (this.getFunctionMap().get(callee) == null) continue;
            if (this.getReverseCallMap().get(callee) == null) {
                this.getReverseCallMap().put(callee, new ArrayList());
            }
            List<String> list = this.getReverseCallMap().get(callee);
            Intrinsics.checkNotNull(list);
            ((Collection)list).add(caller);
        }
    }

    private final void updateDependencyInjection(CodeDataStruct node) {
        block5: {
            Object v1;
            String canonicalName;
            block4: {
                Object v0;
                Object it;
                Object object2;
                block3: {
                    Iterable iterable = node.getAnnotations();
                    for (Object object2 : iterable) {
                        it = (CodeAnnotation)object2;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual((Object)((CodeAnnotation)it).getName(), (Object)"Service") || Intrinsics.areEqual((Object)((CodeAnnotation)it).getName(), (Object)"Component") || Intrinsics.areEqual((Object)((CodeAnnotation)it).getName(), (Object)"Repository"))) continue;
                        v0 = object2;
                        break block3;
                    }
                    v0 = null;
                }
                CodeAnnotation hasInjectionAnnotation = v0;
                if (hasInjectionAnnotation == null || !(!((Collection)node.getImplements()).isEmpty())) break block5;
                canonicalName = node.getPackage() + '.' + node.getNodeName();
                object2 = node.getImplements();
                it = object2.iterator();
                while (it.hasNext()) {
                    Object e = it.next();
                    String it2 = (String)e;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)node.getNodeName(), (Object)(StringsKt.substringAfterLast$default((String)it2, (String)".", null, (int)2, null) + "Impl"))) continue;
                    v1 = e;
                    break block4;
                }
                v1 = null;
            }
            String string = v1;
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.getInjectionMap().put(canonicalName, it);
            }
        }
    }
}

