/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.linter.rule.sql.rules;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import org.archguard.linter.rule.sql.SqlRule;
import org.archguard.rule.core.IssuePosition;
import org.archguard.rule.core.Rule;
import org.archguard.rule.core.Severity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002JX\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2:\u0010\n\u001a6\u0012\u0013\u0012\u00110\f\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\u00040\u000bj\u0002`\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/archguard/linter/rule/sql/rules/LikeStartWithoutPercentRule;", "Lorg/archguard/linter/rule/sql/SqlRule;", "()V", "visitSelect", "", "select", "Lnet/sf/jsqlparser/statement/select/Select;", "context", "", "Lorg/archguard/rule/core/RuleContext;", "callback", "Lkotlin/Function2;", "Lorg/archguard/rule/core/Rule;", "Lkotlin/ParameterName;", "name", "rule", "Lorg/archguard/rule/core/IssuePosition;", "position", "Lorg/archguard/rule/core/IssueEmit;", "rule-sql"})
public final class LikeStartWithoutPercentRule
extends SqlRule {
    public LikeStartWithoutPercentRule() {
        this.setId("like-start-without-percent");
        this.setName("LikeStartWithoutPercent");
        String string = ((Object)((Object)this)).getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.javaClass.name");
        this.setKey(string);
        this.setDescription("\u4f7f\u7528 like \u6a21\u7cca\u5339\u914d\u65f6\uff0c\u67e5\u627e\u5b57\u7b26\u4e32\u4e2d\u901a\u914d\u7b26 % \u653e\u9996\u4f4d\u4f1a\u5bfc\u81f4\u65e0\u6cd5\u4f7f\u7528\u7d22\u5f15\u3002");
        this.setSeverity(Severity.INFO);
    }

    @Override
    public void visitSelect(@NotNull Select select, @NotNull Object context, @NotNull Function2<? super Rule, ? super IssuePosition, Unit> callback) {
        Expression right;
        Expression where;
        Intrinsics.checkNotNullParameter((Object)select, (String)"select");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        SelectBody selectBody = select.getSelectBody();
        if (selectBody instanceof PlainSelect && (where = ((PlainSelect)selectBody).getWhere()) instanceof LikeExpression && (right = ((LikeExpression)where).getRightExpression()) instanceof StringValue) {
            String string = ((StringValue)right).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"right.value");
            if (StringsKt.startsWith$default((String)string, (String)"%", (boolean)false, (int)2, null)) {
                callback.invoke((Object)this, (Object)new IssuePosition(0, 0, 0, 0, null, 31, null));
            }
        }
    }
}

