/*
 * Decompiled with CFR 0.152.
 */
package chapi.ast.csharpast;

import chapi.ast.antlr.CSharpParser;
import chapi.ast.antlr.CSharpParserBaseListener;
import chapi.domain.core.AnnotationKeyValue;
import chapi.domain.core.CodeAnnotation;
import chapi.domain.core.CodeContainer;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeFunction;
import chapi.domain.core.CodeImport;
import chapi.domain.core.CodePackage;
import chapi.domain.core.CodePosition;
import chapi.domain.core.CodeProperty;
import chapi.infra.Stack;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u0003042\u0006\u00105\u001a\u000206H\u0004J\u0018\u00107\u001a\b\u0012\u0004\u0012\u000208042\b\u00109\u001a\u0004\u0018\u00010:H\u0002J\u0010\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020>H\u0002JF\u0010?\u001a\u00020\u001d2\u0006\u0010@\u001a\u00020\u00032\f\u0010A\u001a\b\u0012\u0004\u0012\u00020B042\u0006\u0010C\u001a\u00020\u00032\f\u0010D\u001a\b\u0012\u0004\u0012\u00020\u0003042\u0006\u0010E\u001a\u00020\u00032\b\u0010F\u001a\u0004\u0018\u00010:H\u0004J\u0012\u0010G\u001a\u00020H2\b\u0010=\u001a\u0004\u0018\u00010IH\u0016J\u0012\u0010J\u001a\u00020H2\b\u0010=\u001a\u0004\u0018\u00010KH\u0016J\u0012\u0010L\u001a\u00020H2\b\u0010=\u001a\u0004\u0018\u00010MH\u0016J\u0012\u0010N\u001a\u00020H2\b\u0010=\u001a\u0004\u0018\u00010OH\u0016J\u0012\u0010P\u001a\u00020H2\b\u0010=\u001a\u0004\u0018\u00010IH\u0016J\u0012\u0010Q\u001a\u00020H2\b\u0010=\u001a\u0004\u0018\u00010RH\u0016J\u0006\u0010S\u001a\u00020\u0006J\u0010\u0010T\u001a\u00020H2\u0006\u0010U\u001a\u00020VH\u0002J\u0018\u0010W\u001a\b\u0012\u0004\u0012\u00020B042\b\u0010X\u001a\u0004\u0018\u00010YH\u0004J\u0010\u0010Z\u001a\u00020\u00032\u0006\u0010[\u001a\u00020\\H\u0002J\u0010\u0010]\u001a\u00020H2\u0006\u0010^\u001a\u00020\u0006H\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR0\u0010\u000b\u001a\u0018\u0012\b\u0012\u00060\u0003j\u0002`\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u000e0\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\b\"\u0004\b\u001b\u0010\nR\u001a\u0010\u001c\u001a\u00020\u001dX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010\u0004R\u001a\u0010&\u001a\u00020'X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020-X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010$\u00a8\u0006_"}, d2={"Lchapi/ast/csharpast/CSharpAstListener;", "Lchapi/ast/antlr/CSharpParserBaseListener;", "fileName", "", "(Ljava/lang/String;)V", "codeContainer", "Lchapi/domain/core/CodeContainer;", "getCodeContainer", "()Lchapi/domain/core/CodeContainer;", "setCodeContainer", "(Lchapi/domain/core/CodeContainer;)V", "containerMap", "", "Lchapi/ast/csharpast/PackageName;", "", "getContainerMap", "()Ljava/util/Map;", "setContainerMap", "(Ljava/util/Map;)V", "containerStack", "Lchapi/infra/Stack;", "getContainerStack", "()Lchapi/infra/Stack;", "setContainerStack", "(Lchapi/infra/Stack;)V", "currentContainer", "getCurrentContainer", "setCurrentContainer", "currentFunction", "Lchapi/domain/core/CodeFunction;", "getCurrentFunction", "()Lchapi/domain/core/CodeFunction;", "setCurrentFunction", "(Lchapi/domain/core/CodeFunction;)V", "currentNamespace", "getCurrentNamespace", "()Ljava/lang/String;", "setCurrentNamespace", "currentPackage", "Lchapi/domain/core/CodePackage;", "getCurrentPackage", "()Lchapi/domain/core/CodePackage;", "setCurrentPackage", "(Lchapi/domain/core/CodePackage;)V", "currentStruct", "Lchapi/domain/core/CodeDataStruct;", "getCurrentStruct", "()Lchapi/domain/core/CodeDataStruct;", "setCurrentStruct", "(Lchapi/domain/core/CodeDataStruct;)V", "getFileName", "buildFunctionModifiers", "", "memberCtx", "Lchapi/ast/antlr/CSharpParser$Class_member_declarationContext;", "buildFunctionParameters", "Lchapi/domain/core/CodeProperty;", "formalParameterList", "Lchapi/ast/antlr/CSharpParser$Formal_parameter_listContext;", "buildPosition", "Lchapi/domain/core/CodePosition;", "ctx", "Lorg/antlr/v4/runtime/ParserRuleContext;", "createFunction", "returnType", "annotations", "Lchapi/domain/core/CodeAnnotation;", "packageName", "modifiers", "methodName", "formalParameterListcontext", "enterClass_definition", "", "Lchapi/ast/antlr/CSharpParser$Class_definitionContext;", "enterCompilation_unit", "Lchapi/ast/antlr/CSharpParser$Compilation_unitContext;", "enterNamespace_member_declaration", "Lchapi/ast/antlr/CSharpParser$Namespace_member_declarationContext;", "enterUsing_directives", "Lchapi/ast/antlr/CSharpParser$Using_directivesContext;", "exitClass_definition", "exitNamespace_declaration", "Lchapi/ast/antlr/CSharpParser$Namespace_declarationContext;", "getNodeInfo", "handleDirective", "usingCtx", "Lchapi/ast/antlr/CSharpParser$Using_directiveContext;", "parseAnnotations", "attributes", "Lchapi/ast/antlr/CSharpParser$AttributesContext;", "parseString", "stringLiteral", "Lchapi/ast/antlr/CSharpParser$String_literalContext;", "pushContainer", "container", "chapi-ast-csharp"})
public class CSharpAstListener
extends CSharpParserBaseListener {
    @NotNull
    private final String fileName;
    @NotNull
    private String currentNamespace;
    @NotNull
    private CodeDataStruct currentStruct;
    @NotNull
    private CodeContainer codeContainer;
    @NotNull
    private CodeContainer currentContainer;
    @NotNull
    private Stack<CodeContainer> containerStack;
    @NotNull
    private CodePackage currentPackage;
    @NotNull
    private CodeFunction currentFunction;
    @NotNull
    private Map<String, ? extends List<CodeContainer>> containerMap;

    public CSharpAstListener(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.fileName = fileName;
        this.currentNamespace = "";
        this.currentStruct = new CodeDataStruct(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 524287, null);
        this.currentContainer = this.codeContainer = new CodeContainer(this.getFileName(), null, null, null, null, null, null, 126, null);
        this.containerStack = new Stack();
        this.currentPackage = new CodePackage(null, null, null, null, null, 31, null);
        this.currentFunction = new CodeFunction(null, null, null, null, null, null, null, null, false, null, null, null, null, null, null, false, false, 0, null, null, 1048575, null);
        this.containerMap = MapsKt.emptyMap();
    }

    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    @NotNull
    protected final String getCurrentNamespace() {
        return this.currentNamespace;
    }

    protected final void setCurrentNamespace(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.currentNamespace = string;
    }

    @NotNull
    protected final CodeDataStruct getCurrentStruct() {
        return this.currentStruct;
    }

    protected final void setCurrentStruct(@NotNull CodeDataStruct codeDataStruct) {
        Intrinsics.checkNotNullParameter((Object)codeDataStruct, (String)"<set-?>");
        this.currentStruct = codeDataStruct;
    }

    @NotNull
    protected final CodeContainer getCodeContainer() {
        return this.codeContainer;
    }

    protected final void setCodeContainer(@NotNull CodeContainer codeContainer) {
        Intrinsics.checkNotNullParameter((Object)codeContainer, (String)"<set-?>");
        this.codeContainer = codeContainer;
    }

    @NotNull
    protected final CodeContainer getCurrentContainer() {
        return this.currentContainer;
    }

    protected final void setCurrentContainer(@NotNull CodeContainer codeContainer) {
        Intrinsics.checkNotNullParameter((Object)codeContainer, (String)"<set-?>");
        this.currentContainer = codeContainer;
    }

    @NotNull
    protected final Stack<CodeContainer> getContainerStack() {
        return this.containerStack;
    }

    protected final void setContainerStack(@NotNull Stack<CodeContainer> stack) {
        Intrinsics.checkNotNullParameter(stack, (String)"<set-?>");
        this.containerStack = stack;
    }

    @NotNull
    protected final CodePackage getCurrentPackage() {
        return this.currentPackage;
    }

    protected final void setCurrentPackage(@NotNull CodePackage codePackage) {
        Intrinsics.checkNotNullParameter((Object)codePackage, (String)"<set-?>");
        this.currentPackage = codePackage;
    }

    @NotNull
    protected final CodeFunction getCurrentFunction() {
        return this.currentFunction;
    }

    protected final void setCurrentFunction(@NotNull CodeFunction codeFunction) {
        Intrinsics.checkNotNullParameter((Object)codeFunction, (String)"<set-?>");
        this.currentFunction = codeFunction;
    }

    @NotNull
    protected final Map<String, List<CodeContainer>> getContainerMap() {
        return this.containerMap;
    }

    protected final void setContainerMap(@NotNull Map<String, ? extends List<CodeContainer>> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.containerMap = map;
    }

    @Override
    public void enterCompilation_unit(@Nullable CSharpParser.Compilation_unitContext ctx) {
        this.containerStack.push(this.codeContainer);
    }

    @Override
    public void enterUsing_directives(@Nullable CSharpParser.Using_directivesContext ctx) {
        CSharpParser.Using_directivesContext using_directivesContext = ctx;
        Intrinsics.checkNotNull((Object)using_directivesContext);
        Iterator<CSharpParser.Using_directiveContext> iterator = using_directivesContext.using_directive().iterator();
        while (iterator.hasNext()) {
            CSharpParser.Using_directiveContext usingCtx;
            CSharpParser.Using_directiveContext using_directiveContext = usingCtx = iterator.next();
            Intrinsics.checkNotNull((Object)using_directiveContext);
            this.handleDirective(using_directiveContext);
        }
    }

    private final void handleDirective(CSharpParser.Using_directiveContext usingCtx) {
        String usingType = usingCtx.getClass().getSimpleName();
        CodeImport codeImport = new CodeImport(null, null, null, null, 15, null);
        Object object = usingType;
        if (Intrinsics.areEqual((Object)object, (Object)"UsingNamespaceDirectiveContext")) {
            CSharpParser.UsingNamespaceDirectiveContext directiveCtx = (CSharpParser.UsingNamespaceDirectiveContext)usingCtx;
            String string = directiveCtx.namespace_or_type_name().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"directiveCtx.namespace_or_type_name().text");
            codeImport.setSource(string);
        } else if (Intrinsics.areEqual((Object)object, (Object)"UsingAliasDirectiveContext")) {
            CSharpParser.UsingAliasDirectiveContext alisCtx = (CSharpParser.UsingAliasDirectiveContext)usingCtx;
            String string = alisCtx.namespace_or_type_name().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"alisCtx.namespace_or_type_name().text");
            codeImport.setSource(string);
            string = alisCtx.identifier().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"alisCtx.identifier().text");
            codeImport.setAsName(string);
        } else {
            System.out.println((Object)Intrinsics.stringPlus((String)"handleDirective: ", (Object)usingType));
        }
        object = this.codeContainer;
        ((CodeContainer)object).setImports(CollectionsKt.plus((Collection)((CodeContainer)object).getImports(), (Object)codeImport));
    }

    @Override
    public void enterNamespace_member_declaration(@Nullable CSharpParser.Namespace_member_declarationContext ctx) {
        CSharpParser.Namespace_member_declarationContext namespace_member_declarationContext = ctx;
        Intrinsics.checkNotNull((Object)namespace_member_declarationContext);
        CSharpParser.Namespace_declarationContext namespaceDeclaration = namespace_member_declarationContext.namespace_declaration();
        if (namespaceDeclaration != null && namespaceDeclaration.qualified_identifier() != null) {
            String nsName = ctx.namespace_declaration().qualified_identifier().getText();
            Intrinsics.checkNotNullExpressionValue((Object)nsName, (String)"nsName");
            this.currentNamespace = nsName;
            CodeContainer container = new CodeContainer(this.getFileName(), nsName, null, null, null, null, null, 124, null);
            this.pushContainer(container);
        }
    }

    private final void pushContainer(CodeContainer container) {
        this.currentContainer = container;
        int DEFAULT_CODE_CONTAINER = 1;
        if (this.containerStack.getElements().size() > DEFAULT_CODE_CONTAINER) {
            CodeContainer lastContainer = (CodeContainer)CollectionsKt.last(this.containerStack.getElements());
            lastContainer.setContainers(CollectionsKt.plus((Collection)lastContainer.getContainers(), (Object)this.currentContainer));
            this.containerStack.getElements().set(this.containerStack.getElements().size() - 1, lastContainer);
            this.containerStack.push(this.currentContainer);
        } else {
            CodeContainer codeContainer = this.codeContainer;
            codeContainer.setContainers(CollectionsKt.plus((Collection)codeContainer.getContainers(), (Object)this.currentContainer));
            this.containerStack.push(this.currentContainer);
        }
    }

    @Override
    public void exitNamespace_declaration(@Nullable CSharpParser.Namespace_declarationContext ctx) {
        this.containerStack.pop();
    }

    @Override
    public void enterClass_definition(@Nullable CSharpParser.Class_definitionContext ctx) {
        CodeDataStruct codeDataStruct;
        CSharpParser.Class_definitionContext class_definitionContext = ctx;
        Intrinsics.checkNotNull((Object)class_definitionContext);
        String className = class_definitionContext.identifier().getText();
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"className");
        this.currentStruct = codeDataStruct = new CodeDataStruct(className, null, null, this.currentNamespace, null, null, null, null, null, null, null, null, null, null, null, null, null, this.buildPosition(ctx), null, 393206, null);
        RuleContext parent = ctx.parent;
        if (Intrinsics.areEqual((Object)parent.getClass().getSimpleName(), (Object)"Type_declarationContext")) {
            RuleContext ruleContext = parent;
            if (ruleContext == null) {
                throw new NullPointerException("null cannot be cast to non-null type chapi.ast.antlr.CSharpParser.Type_declarationContext");
            }
            CSharpParser.Type_declarationContext typeDecl = (CSharpParser.Type_declarationContext)ruleContext;
            this.currentStruct.setAnnotations(this.parseAnnotations(typeDecl.attributes()));
        }
    }

    @Override
    public void exitClass_definition(@Nullable CSharpParser.Class_definitionContext ctx) {
        CodeContainer codeContainer = this.currentContainer;
        codeContainer.setDataStructures(CollectionsKt.plus((Collection)codeContainer.getDataStructures(), (Object)this.currentStruct));
    }

    @NotNull
    protected final List<CodeAnnotation> parseAnnotations(@Nullable CSharpParser.AttributesContext attributes) {
        List annotations = null;
        annotations = CollectionsKt.emptyList();
        CSharpParser.AttributesContext attributesContext = attributes;
        if (attributesContext != null) {
            List<CSharpParser.Attribute_sectionContext> list = attributesContext.attribute_section();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CSharpParser.Attribute_sectionContext it = (CSharpParser.Attribute_sectionContext)element$iv;
                    boolean bl = false;
                    List<CSharpParser.AttributeContext> list2 = it.attribute_list().attribute();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"it.attribute_list().attribute()");
                    Iterable $this$forEach$iv2 = list2;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        CSharpParser.AttributeContext attr = (CSharpParser.AttributeContext)element$iv2;
                        boolean bl2 = false;
                        Object object = attr.namespace_or_type_name().getText();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"attr.namespace_or_type_name().text");
                        CodeAnnotation annotation = new CodeAnnotation((String)object, null, 2, null);
                        object = attr.attribute_argument();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"attr.attribute_argument()");
                        Iterable $this$forEach$iv3 = (Iterable)object;
                        boolean $i$f$forEach3 = false;
                        for (Object element$iv3 : $this$forEach$iv3) {
                            Object object2;
                            CSharpParser.Attribute_argumentContext it2 = (CSharpParser.Attribute_argumentContext)element$iv3;
                            boolean bl3 = false;
                            if (it2.string_literal() != null) {
                                Collection collection = annotation.getKeyValues();
                                object2 = it2.string_literal();
                                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.string_literal()");
                                annotation.setKeyValues(CollectionsKt.plus((Collection)collection, (Object)new AnnotationKeyValue(null, this.parseString((CSharpParser.String_literalContext)object2), 1, null)));
                                continue;
                            }
                            Collection collection = annotation.getKeyValues();
                            object2 = it2.getText();
                            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"it.text");
                            annotation.setKeyValues(CollectionsKt.plus((Collection)collection, (Object)new AnnotationKeyValue(null, (String)object2, 1, null)));
                        }
                        annotations = CollectionsKt.plus((Collection)annotations, (Object)annotation);
                    }
                }
            }
        }
        return annotations;
    }

    private final String parseString(CSharpParser.String_literalContext stringLiteral) {
        String str = "";
        if (stringLiteral.REGULAR_STRING() != null) {
            String text = stringLiteral.getText();
            Intrinsics.checkNotNullExpressionValue((Object)text, (String)"text");
            String string = text.substring(1, text.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            str = string;
        }
        return str;
    }

    @NotNull
    protected final CodeFunction createFunction(@NotNull String returnType, @NotNull List<CodeAnnotation> annotations, @NotNull String packageName, @NotNull List<String> modifiers, @NotNull String methodName, @Nullable CSharpParser.Formal_parameter_listContext formalParameterListcontext) {
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        CodeFunction codeFunction = new CodeFunction(methodName, null, packageName, returnType, null, null, null, annotations, false, modifiers, null, null, null, null, null, false, false, 0, null, null, 1047922, null);
        if (formalParameterListcontext != null) {
            codeFunction.setParameters(this.buildFunctionParameters(formalParameterListcontext));
        }
        return codeFunction;
    }

    private final List<CodeProperty> buildFunctionParameters(CSharpParser.Formal_parameter_listContext formalParameterList) {
        List parameters = CollectionsKt.emptyList();
        CSharpParser.Formal_parameter_listContext formal_parameter_listContext = formalParameterList;
        Intrinsics.checkNotNull((Object)formal_parameter_listContext);
        if (formal_parameter_listContext.fixed_parameters() != null) {
            for (CSharpParser.Fixed_parameterContext fixedParamCtx : formalParameterList.fixed_parameters().fixed_parameter()) {
                CSharpParser.Arg_declarationContext argDeclCtx = fixedParamCtx.arg_declaration();
                if (argDeclCtx == null) continue;
                String string = argDeclCtx.type_().getText();
                String string2 = argDeclCtx.identifier().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"text");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
                CodeProperty parameter = new CodeProperty(null, null, string2, string, null, null, null, null, 243, null);
                parameters = CollectionsKt.plus((Collection)parameters, (Object)parameter);
            }
        }
        return parameters;
    }

    @NotNull
    protected final List<String> buildFunctionModifiers(@NotNull CSharpParser.Class_member_declarationContext memberCtx) {
        Intrinsics.checkNotNullParameter((Object)memberCtx, (String)"memberCtx");
        List modifiers = CollectionsKt.emptyList();
        CSharpParser.All_member_modifiersContext allMemberModifiers = memberCtx.all_member_modifiers();
        if (allMemberModifiers != null) {
            for (CSharpParser.All_member_modifierContext memberModifier : allMemberModifiers.all_member_modifier()) {
                modifiers = CollectionsKt.plus((Collection)modifiers, (Object)memberModifier.getText());
            }
        }
        return modifiers;
    }

    private final CodePosition buildPosition(ParserRuleContext ctx) {
        CodePosition position = new CodePosition(0, 0, 0, 0, 15, null);
        position.setStartLine(ctx.start.getLine());
        position.setStartLinePosition(ctx.start.getCharPositionInLine());
        position.setStopLine(ctx.stop.getLine());
        position.setStopLinePosition(ctx.stop.getCharPositionInLine());
        return position;
    }

    @NotNull
    public final CodeContainer getNodeInfo() {
        return this.codeContainer;
    }
}

