/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.reflection.ParamNameUtil;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

public class ParamNameResolver {
    public static final String GENERIC_NAME_PREFIX = "param";
    private final boolean useActualParamName;
    private final SortedMap<Integer, String> names;
    private boolean hasParamAnnotation;

    public ParamNameResolver(Configuration config, Method method) {
        this.useActualParamName = config.isUseActualParamName();
        Class<?>[] paramTypes = method.getParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        int paramCount = paramAnnotations.length;
        for (int paramIndex = 0; paramIndex < paramCount; ++paramIndex) {
            if (ParamNameResolver.isSpecialParameter(paramTypes[paramIndex])) continue;
            String name = null;
            for (Annotation annotation2 : paramAnnotations[paramIndex]) {
                if (!(annotation2 instanceof Param)) continue;
                this.hasParamAnnotation = true;
                name = ((Param)annotation2).value();
                break;
            }
            if (name == null) {
                if (this.useActualParamName) {
                    name = this.getActualParamName(method, paramIndex);
                }
                if (name == null) {
                    name = String.valueOf(map.size());
                }
            }
            map.put(paramIndex, name);
        }
        this.names = Collections.unmodifiableSortedMap(map);
    }

    private String getActualParamName(Method method, int paramIndex) {
        return ParamNameUtil.getParamNames(method).get(paramIndex);
    }

    private static boolean isSpecialParameter(Class<?> clazz) {
        return RowBounds.class.isAssignableFrom(clazz) || ResultHandler.class.isAssignableFrom(clazz);
    }

    public String[] getNames() {
        return this.names.values().toArray(new String[0]);
    }

    public Object getNamedParams(Object[] args) {
        int paramCount = this.names.size();
        if (args == null || paramCount == 0) {
            return null;
        }
        if (!this.hasParamAnnotation && paramCount == 1) {
            Object value = args[this.names.firstKey()];
            return ParamNameResolver.wrapToMapIfCollection(value, this.useActualParamName ? (String)this.names.get(0) : null);
        }
        MapperMethod.ParamMap<Object> param = new MapperMethod.ParamMap<Object>();
        int i = 0;
        for (Map.Entry<Integer, String> entry : this.names.entrySet()) {
            param.put(entry.getValue(), args[entry.getKey()]);
            String genericParamName = GENERIC_NAME_PREFIX + (i + 1);
            if (!this.names.containsValue(genericParamName)) {
                param.put(genericParamName, args[entry.getKey()]);
            }
            ++i;
        }
        return param;
    }

    public static Object wrapToMapIfCollection(Object object, String actualParamName) {
        if (object instanceof Collection) {
            MapperMethod.ParamMap<Object> map = new MapperMethod.ParamMap<Object>();
            map.put("collection", object);
            if (object instanceof List) {
                map.put("list", object);
            }
            Optional.ofNullable(actualParamName).ifPresent(name -> map.put(name, object));
            return map;
        }
        if (object != null && object.getClass().isArray()) {
            MapperMethod.ParamMap<Object> map = new MapperMethod.ParamMap<Object>();
            map.put("array", object);
            Optional.ofNullable(actualParamName).ifPresent(name -> map.put(name, object));
            return map;
        }
        return object;
    }
}

