/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.cache.decorators;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.CacheException;

public class BlockingCache
implements Cache {
    private long timeout;
    private final Cache delegate;
    private final ConcurrentHashMap<Object, CountDownLatch> locks;

    public BlockingCache(Cache delegate2) {
        this.delegate = delegate2;
        this.locks = new ConcurrentHashMap();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public int getSize() {
        return this.delegate.getSize();
    }

    @Override
    public void putObject(Object key, Object value) {
        try {
            this.delegate.putObject(key, value);
        }
        finally {
            this.releaseLock(key);
        }
    }

    @Override
    public Object getObject(Object key) {
        this.acquireLock(key);
        Object value = this.delegate.getObject(key);
        if (value != null) {
            this.releaseLock(key);
        }
        return value;
    }

    @Override
    public Object removeObject(Object key) {
        this.releaseLock(key);
        return null;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    private void acquireLock(Object key) {
        CountDownLatch latch;
        CountDownLatch newLatch = new CountDownLatch(1);
        while ((latch = this.locks.putIfAbsent(key, newLatch)) != null) {
            try {
                if (this.timeout > 0L) {
                    boolean acquired = latch.await(this.timeout, TimeUnit.MILLISECONDS);
                    if (acquired) continue;
                    throw new CacheException("Couldn't get a lock in " + this.timeout + " for the key " + key + " at the cache " + this.delegate.getId());
                }
                latch.await();
            }
            catch (InterruptedException e) {
                throw new CacheException("Got interrupted while trying to acquire lock for key " + key, e);
            }
        }
    }

    private void releaseLock(Object key) {
        CountDownLatch latch = this.locks.remove(key);
        if (latch == null) {
            throw new IllegalStateException("Detected an attempt at releasing unacquired lock. This should never happen.");
        }
        latch.countDown();
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

