/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsqlparser.expression;

import java.util.Arrays;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.KeepExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;

public class Function
extends ASTNodeAccessImpl
implements Expression {
    private List<String> nameparts;
    private ExpressionList parameters;
    private NamedExpressionList namedParameters;
    private boolean allColumns = false;
    private boolean distinct = false;
    private boolean unique = false;
    private boolean isEscaped = false;
    private Expression attribute;
    private String attributeName;
    private List<OrderByElement> orderByElements;
    private KeepExpression keep = null;
    private boolean ignoreNulls = false;

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String getName() {
        return this.nameparts == null ? null : String.join((CharSequence)".", this.nameparts);
    }

    public List<String> getMultipartName() {
        return this.nameparts;
    }

    public void setName(String string) {
        this.nameparts = Arrays.asList(string);
    }

    public Function withName(String name) {
        this.setName(name);
        return this;
    }

    public void setName(List<String> string) {
        this.nameparts = string;
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(boolean b) {
        this.allColumns = b;
    }

    public boolean isIgnoreNulls() {
        return this.ignoreNulls;
    }

    public void setIgnoreNulls(boolean ignoreNulls) {
        this.ignoreNulls = ignoreNulls;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean b) {
        this.distinct = b;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean b) {
        this.unique = b;
    }

    public ExpressionList getParameters() {
        return this.parameters;
    }

    public void setParameters(ExpressionList list) {
        this.parameters = list;
    }

    public NamedExpressionList getNamedParameters() {
        return this.namedParameters;
    }

    public void setNamedParameters(NamedExpressionList list) {
        this.namedParameters = list;
    }

    public boolean isEscaped() {
        return this.isEscaped;
    }

    public void setEscaped(boolean isEscaped) {
        this.isEscaped = isEscaped;
    }

    public Expression getAttribute() {
        return this.attribute;
    }

    public void setAttribute(Expression attribute) {
        this.attribute = attribute;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public KeepExpression getKeep() {
        return this.keep;
    }

    public void setKeep(KeepExpression keep) {
        this.keep = keep;
    }

    public String toString() {
        String params2;
        if (this.parameters != null || this.namedParameters != null) {
            if (this.parameters != null) {
                StringBuilder b = new StringBuilder();
                b.append("(");
                if (this.isDistinct()) {
                    b.append("DISTINCT ");
                } else if (this.isUnique()) {
                    b.append("UNIQUE ");
                }
                if (this.isAllColumns()) {
                    b.append("ALL ");
                }
                b.append(PlainSelect.getStringList(this.parameters.getExpressions(), true, false));
                if (this.orderByElements != null) {
                    b.append(" ORDER BY ");
                    boolean comma = false;
                    for (OrderByElement orderByElement : this.orderByElements) {
                        if (comma) {
                            b.append(", ");
                        } else {
                            comma = true;
                        }
                        b.append(orderByElement);
                    }
                }
                b.append(")");
                params2 = b.toString();
            } else {
                params2 = this.namedParameters.toString();
            }
        } else {
            params2 = "()";
        }
        String ans = this.getName() + params2;
        if (this.attribute != null) {
            ans = ans + "." + this.attribute.toString();
        } else if (this.attributeName != null) {
            ans = ans + "." + this.attributeName;
        }
        if (this.keep != null) {
            ans = ans + " " + this.keep.toString();
        }
        if (this.isEscaped) {
            ans = "{fn " + ans + "}";
        }
        return ans;
    }

    public Function withAttribute(Expression attribute) {
        this.setAttribute(attribute);
        return this;
    }

    public Function withAttributeName(String attributeName) {
        this.setAttributeName(attributeName);
        return this;
    }

    public Function withKeep(KeepExpression keep) {
        this.setKeep(keep);
        return this;
    }

    public Function withIgnoreNulls(boolean ignoreNulls) {
        this.setIgnoreNulls(ignoreNulls);
        return this;
    }

    public Function withParameters(ExpressionList parameters) {
        this.setParameters(parameters);
        return this;
    }

    public Function withNamedParameters(NamedExpressionList namedParameters) {
        this.setNamedParameters(namedParameters);
        return this;
    }

    public Function withAllColumns(boolean allColumns) {
        this.setAllColumns(allColumns);
        return this;
    }

    public Function withDistinct(boolean distinct) {
        this.setDistinct(distinct);
        return this;
    }

    public Function withUnique(boolean unique) {
        this.setUnique(unique);
        return this;
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> orderByElements) {
        this.orderByElements = orderByElements;
    }

    public <E extends Expression> E getAttribute(Class<E> type) {
        return (E)((Expression)type.cast(this.getAttribute()));
    }
}

