/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser;

import chapi.domain.core.CodeDataStruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.archguard.scanner.analyser.database.JvmSqlAnalyser;
import org.archguard.scanner.analyser.xml.XmlParser;
import org.archguard.scanner.analyser.xml.mybatis.MybatisEntry;
import org.archguard.scanner.core.client.ArchGuardClient;
import org.archguard.scanner.core.sourcecode.ASTSourceCodeAnalyser;
import org.archguard.scanner.core.sourcecode.CodeDatabaseRelation;
import org.archguard.scanner.core.sourcecode.SourceCodeContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/archguard/scanner/analyser/DataMapAnalyser;", "Lorg/archguard/scanner/core/sourcecode/ASTSourceCodeAnalyser;", "context", "Lorg/archguard/scanner/core/sourcecode/SourceCodeContext;", "(Lorg/archguard/scanner/core/sourcecode/SourceCodeContext;)V", "client", "Lorg/archguard/scanner/core/client/ArchGuardClient;", "getContext", "()Lorg/archguard/scanner/core/sourcecode/SourceCodeContext;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "analyse", "", "Lorg/archguard/scanner/core/sourcecode/CodeDatabaseRelation;", "input", "Lchapi/domain/core/CodeDataStruct;", "feat_datamap"})
@SourceDebugExtension(value={"SMAP\nDataMapAnalyser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataMapAnalyser.kt\norg/archguard/scanner/analyser/DataMapAnalyser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,38:1\n1360#2:39\n1446#2,5:40\n*S KotlinDebug\n*F\n+ 1 DataMapAnalyser.kt\norg/archguard/scanner/analyser/DataMapAnalyser\n*L\n23#1:39\n23#1:40,5\n*E\n"})
public final class DataMapAnalyser
implements ASTSourceCodeAnalyser {
    @NotNull
    private final SourceCodeContext context;
    @NotNull
    private final ArchGuardClient client;
    private final Logger logger;

    public DataMapAnalyser(@NotNull SourceCodeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.client = this.getContext().getClient();
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @NotNull
    public SourceCodeContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<CodeDatabaseRelation> analyse(@NotNull List<CodeDataStruct> input) {
        Collection destination$iv$iv;
        JvmSqlAnalyser sqlAnalyser;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        String string = this.getContext().getLanguage().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String language = string;
        String path = this.getContext().getPath();
        String string2 = language;
        if (Intrinsics.areEqual((Object)string2, (Object)"java") ? true : Intrinsics.areEqual((Object)string2, (Object)"kotlin")) {
            void $this$flatMapTo$iv$iv;
            StringBuilder stringBuilder = new StringBuilder().append("start analysis database api ---- ");
            String string3 = language.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            this.logger.info(stringBuilder.append(string3).toString());
            sqlAnalyser = new JvmSqlAnalyser();
            Iterable $this$flatMap$iv = input;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                CodeDataStruct data = (CodeDataStruct)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = sqlAnalyser.analysisByNode(data, "");
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
        } else {
            throw new IllegalArgumentException("Unsupported language: " + language);
        }
        List records = (List)destination$iv$iv;
        List<MybatisEntry> mybatisEntries = XmlParser.Companion.parseMybatis(path);
        List<CodeDatabaseRelation> relations = sqlAnalyser.convertMyBatis(mybatisEntries);
        List relations2 = CollectionsKt.plus((Collection)relations, (Iterable)records);
        this.client.saveRelation(relations2);
        return relations2;
    }

    @Nullable
    public List<Object> analyse(@Nullable Object input) {
        return ASTSourceCodeAnalyser.DefaultImpls.analyse((ASTSourceCodeAnalyser)this, (Object)input);
    }
}

