/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.archguard.scanner.analyser.database.MysqlIdentApp;
import org.archguard.scanner.analyser.database.SimpleRelation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/archguard/scanner/analyser/database/MysqlIdentApp;", "", "()V", "UPDATE_SQL", "Lkotlin/text/Regex;", "logger", "Lmu/KLogger;", "analysis", "Lorg/archguard/scanner/analyser/database/SimpleRelation;", "sql", "", "feat_datamap"})
public final class MysqlIdentApp {
    @NotNull
    public static final MysqlIdentApp INSTANCE = new MysqlIdentApp();
    @NotNull
    private static final Regex UPDATE_SQL = new Regex("update\\s+([a-zA-Z_]+)");
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);

    private MysqlIdentApp() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SimpleRelation analysis(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        SimpleRelation table = new SimpleRelation(null, null, 3, null);
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"parse(sql)");
            Statement statement2 = statement;
            TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
            List list = tablesNamesFinder.getTableList(statement2);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"tablesNamesFinder.getTableList(statement)");
            Iterable iterable = list;
            SimpleRelation simpleRelation = table;
            boolean $i$f$map = false;
            void var7_11 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String tableName = it;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (StringsKt.startsWith$default((String)it, (String)"`", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)it, (String)"`", (boolean)false, (int)2, null)) {
                    void v2 = tableName;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"tableName");
                    tableName = StringsKt.removePrefix((String)StringsKt.removeSuffix((String)v2, (CharSequence)"`"), (CharSequence)"`");
                }
                collection.add(tableName);
            }
            simpleRelation.setTableNames((List)destination$iv$iv);
        }
        catch (Exception e) {
            if (Regex.find$default((Regex)UPDATE_SQL, (CharSequence)sql, (int)0, (int)2, null) != null) {
                MatchResult matchResult = Regex.find$default((Regex)UPDATE_SQL, (CharSequence)sql, (int)0, (int)2, null);
                Intrinsics.checkNotNull((Object)matchResult);
                MatchGroup matchGroup = matchResult.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                String tableName = matchGroup.getValue();
                Object[] objectArray = new String[]{tableName};
                table.setTableNames(CollectionsKt.arrayListOf((Object[])objectArray));
                return table;
            }
            logger.info("analysis failure for sql: " + sql);
            return null;
        }
        return table;
    }
}

