/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.database;

import chapi.domain.core.CodeAnnotation;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.archguard.scanner.analyser.database.MysqlIdentApp;
import org.archguard.scanner.analyser.database.SimpleRelation;
import org.archguard.scanner.analyser.xml.mybatis.MybatisEntry;
import org.archguard.scanner.core.sourcecode.CodeDatabaseRelation;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0002J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0010\u0010$\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u000e\u0010&\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/archguard/scanner/analyser/database/JvmSqlAnalyser;", "", "()V", "IN_REGEX", "Lkotlin/text/Regex;", "JDBI_VALUE_BIND", "KOTLIN_VARIABLE", "KOTLIN_VARIABLE_WITH_QUOTE", "RAW_STRING_REGEX", "VARIABLE_IN_LINE", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "analysisByNode", "", "Lorg/archguard/scanner/core/sourcecode/CodeDatabaseRelation;", "node", "Lchapi/domain/core/CodeDataStruct;", "workspace", "", "convertMyBatis", "mybatisEntries", "", "Lorg/archguard/scanner/analyser/xml/mybatis/MybatisEntry;", "fillLimitEmpty", "value", "fillOffsetEmpty", "handleRawString", "text", "processIn", "removeBeginEndQuotes", "removeEndWithMultipleSingleQuote", "removeJdbiValueBind", "removeKotlinVariable", "removeNextLine", "removePlusSymbol", "removePlusWithVariable", "removeVariableInLine", "sqlify", "feat_datamap"})
public final class JvmSqlAnalyser {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final Regex RAW_STRING_REGEX = new Regex("\"\"\"(((.*?)|(\r\n|\n))+)\"\"\"");
    @NotNull
    private final Regex VARIABLE_IN_LINE = new Regex("(\"\\\\\"\\+[a-zA-Z0-9_]+\\+\"\\\\\")");
    @NotNull
    private final Regex IN_REGEX = new Regex("in\\s+\\((\\s+)?<([a-zA-Z0-9_]+)>(\\s+)?\\)");
    @NotNull
    private final Regex JDBI_VALUE_BIND = new Regex(":([a-zA-Z0-9_]+)");
    @NotNull
    private final Regex KOTLIN_VARIABLE_WITH_QUOTE = new Regex("'\\$([a-zA-Z0-9_]+)'");
    @NotNull
    private final Regex KOTLIN_VARIABLE = new Regex("\\$([a-zA-Z0-9_]+)");

    @NotNull
    public final List<CodeDatabaseRelation> analysisByNode(@NotNull CodeDataStruct node, @NotNull String workspace) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        List relations = new ArrayList();
        CodeFunction[] $this$forEach$iv = node.getFunctions();
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            Object originSql;
            CodeAnnotation it;
            CodeAnnotation element$iv;
            int n2;
            CodeFunction element$iv2;
            CodeFunction function = element$iv2 = $this$forEach$iv[i];
            boolean bl = false;
            List sqls = new ArrayList();
            Set tables = new LinkedHashSet();
            CodeAnnotation[] $this$forEach$iv2 = function.getAnnotations();
            boolean $i$f$forEach2 = false;
            int n3 = $this$forEach$iv2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                it = element$iv = $this$forEach$iv2[n2];
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"Query") && !Intrinsics.areEqual((Object)it.getName(), (Object)"SqlQuery") || !(!(it.getKeyValues().length == 0))) continue;
                originSql = it.getKeyValues()[0].getValue();
                String pureValue = this.sqlify((String)originSql);
                if (MysqlIdentApp.INSTANCE.analysis(pureValue) != null) {
                    Collection collection = tables;
                    SimpleRelation simpleRelation = MysqlIdentApp.INSTANCE.analysis(pureValue);
                    Intrinsics.checkNotNull((Object)simpleRelation);
                    CollectionsKt.addAll((Collection)collection, (Iterable)simpleRelation.getTableNames());
                } else {
                    this.logger.warn("error for " + node.getNodeName() + '.' + function.getName() + " origin:" + (String)originSql + " \nnew:" + pureValue);
                }
                ((Collection)sqls).add(pureValue);
            }
            $this$forEach$iv2 = function.getFunctionCalls();
            $i$f$forEach2 = false;
            n3 = $this$forEach$iv2.length;
            for (n2 = 0; n2 < n3; ++n2) {
                it = element$iv = $this$forEach$iv2[n2];
                boolean bl3 = false;
                originSql = new String[]{"."};
                String callMethodName = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)it.getFunctionName(), (String[])originSql, (boolean)false, (int)0, (int)6, null));
                if (!Intrinsics.areEqual((Object)callMethodName, (Object)"createQuery") || !(!(it.getParameters().length == 0))) continue;
                originSql = it.getParameters()[0].getTypeValue();
                String pureValue = this.sqlify((String)originSql);
                if (MysqlIdentApp.INSTANCE.analysis(pureValue) != null) {
                    Collection collection = tables;
                    SimpleRelation simpleRelation = MysqlIdentApp.INSTANCE.analysis(pureValue);
                    Intrinsics.checkNotNull((Object)simpleRelation);
                    CollectionsKt.addAll((Collection)collection, (Iterable)simpleRelation.getTableNames());
                } else {
                    this.logger.warn("error for " + node.getNodeName() + '.' + function.getName() + " origin:" + (String)originSql + "\nnew:" + pureValue);
                }
                ((Collection)sqls).add(pureValue);
            }
            if (sqls.size() <= 0) continue;
            ((Collection)relations).add(new CodeDatabaseRelation(node.getPackage(), node.getNodeName(), function.getName(), CollectionsKt.toList((Iterable)tables), sqls));
        }
        return relations;
    }

    @NotNull
    public final List<CodeDatabaseRelation> convertMyBatis(@NotNull List<MybatisEntry> mybatisEntries) {
        Intrinsics.checkNotNullParameter(mybatisEntries, (String)"mybatisEntries");
        List relations = new ArrayList();
        Iterable $this$forEach$iv = mybatisEntries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MybatisEntry entry = (MybatisEntry)element$iv;
            boolean bl = false;
            String[] stringArray = new String[]{"."};
            List splits = StringsKt.split$default((CharSequence)entry.getNamespace(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String className = (String)CollectionsKt.last((List)splits);
            CollectionsKt.dropLast((List)splits, (int)1);
            String packageName = CollectionsKt.joinToString$default((Iterable)splits, (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
            Map<String, String> $this$forEach$iv2 = entry.getMethodSqlMap();
            boolean $i$f$forEach2 = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv2;
                Map.Entry<String, String> it = element$iv2 = iterator.next();
                boolean bl2 = false;
                SimpleRelation simpleRelation = MysqlIdentApp.INSTANCE.analysis(it.getValue());
                List tables = simpleRelation != null ? simpleRelation.getTableNames() : null;
                Collection collection = relations;
                List list = tables;
                if (list == null || (list = CollectionsKt.toList((Iterable)list)) == null) {
                    list = CollectionsKt.emptyList();
                }
                collection.add(new CodeDatabaseRelation(packageName, className, it.getKey(), list, CollectionsKt.listOf((Object)it.getValue())));
            }
        }
        return relations;
    }

    @NotNull
    public final String sqlify(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String text = this.handleRawString(value);
        text = this.removeBeginEndQuotes(text);
        text = this.removeVariableInLine(text);
        text = this.removeKotlinVariable(text);
        text = this.removeJdbiValueBind(text);
        text = this.removeEndWithMultipleSingleQuote(text);
        text = this.removeNextLine(text);
        text = this.removePlusWithVariable(text);
        text = this.removePlusSymbol(text);
        text = this.processIn(text);
        text = this.fillLimitEmpty(text);
        text = this.fillOffsetEmpty(text);
        return text;
    }

    private final String handleRawString(String text) {
        MatchResult rawString = Regex.find$default((Regex)this.RAW_STRING_REGEX, (CharSequence)text, (int)0, (int)2, null);
        if (rawString != null) {
            MatchGroup matchGroup = rawString.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            return matchGroup.getValue();
        }
        return text;
    }

    private final String removeVariableInLine(String text) {
        MatchResult find = Regex.find$default((Regex)this.VARIABLE_IN_LINE, (CharSequence)text, (int)0, (int)2, null);
        if (find != null) {
            CharSequence charSequence = text;
            Regex regex = this.VARIABLE_IN_LINE;
            String string = "*";
            return regex.replace(charSequence, string);
        }
        return text;
    }

    private final String processIn(String text) {
        MatchResult find = Regex.find$default((Regex)this.IN_REGEX, (CharSequence)text, (int)0, (int)2, null);
        if (find != null) {
            CharSequence charSequence = text;
            Regex regex = this.IN_REGEX;
            StringBuilder stringBuilder = new StringBuilder().append("in (:");
            MatchGroup matchGroup = find.getGroups().get(2);
            Intrinsics.checkNotNull((Object)matchGroup);
            String string = stringBuilder.append(matchGroup.getValue()).append(')').toString();
            return regex.replace(charSequence, string);
        }
        return text;
    }

    private final String removeJdbiValueBind(String text) {
        MatchResult find = Regex.find$default((Regex)this.JDBI_VALUE_BIND, (CharSequence)text, (int)0, (int)2, null);
        if (find != null) {
            CharSequence charSequence = text;
            Regex regex = this.JDBI_VALUE_BIND;
            String string = "''";
            return regex.replace(charSequence, string);
        }
        return text;
    }

    private final String removeKotlinVariable(String text) {
        MatchResult varFind;
        String string;
        Object object;
        String str = text;
        MatchResult find = Regex.find$default((Regex)this.KOTLIN_VARIABLE_WITH_QUOTE, (CharSequence)str, (int)0, (int)2, null);
        if (find != null) {
            CharSequence charSequence = str;
            object = this.KOTLIN_VARIABLE_WITH_QUOTE;
            string = "''";
            str = object.replace(charSequence, string);
        }
        if ((varFind = Regex.find$default((Regex)this.KOTLIN_VARIABLE, (CharSequence)str, (int)0, (int)2, null)) != null) {
            object = str;
            string = this.KOTLIN_VARIABLE;
            String string2 = "''";
            str = string.replace((CharSequence)object, string2);
        }
        return str;
    }

    private final String removeNextLine(String text) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)text, (String)"\r\n", (String)"", (boolean)false, (int)4, null), (String)"\n", (String)"", (boolean)false, (int)4, null);
    }

    private final String removePlusSymbol(String text) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)text, (String)"\"+\"", (String)"", (boolean)false, (int)4, null), (String)"+\"", (String)"", (boolean)false, (int)4, null);
    }

    private final String removePlusWithVariable(String text) {
        CharSequence charSequence = text;
        Regex regex = new Regex("\"\\+([a-zA-Z0-9_]+)");
        String string = "";
        return regex.replace(charSequence, string);
    }

    private final String removeEndWithMultipleSingleQuote(String text) {
        CharSequence charSequence = text;
        Regex regex = new Regex("''\\s+''");
        String string = "''";
        return regex.replace(charSequence, string);
    }

    private final String removeBeginEndQuotes(String value) {
        if (StringsKt.startsWith$default((String)value, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"\"", (boolean)false, (int)2, null)) {
            return StringsKt.removePrefix((String)StringsKt.removeSuffix((String)value, (CharSequence)"\""), (CharSequence)"\"");
        }
        return value;
    }

    private final String fillLimitEmpty(String value) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)value, (String)"offset ''", (String)"offset 10", (boolean)false, (int)4, null), (String)"OFFSET ''", (String)"OFFSET 10", (boolean)false, (int)4, null);
    }

    private final String fillOffsetEmpty(String value) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)value, (String)"limit ''", (String)"limit 10", (boolean)false, (int)4, null), (String)"LIMIT ''", (String)"LIMIT 10", (boolean)false, (int)4, null);
    }
}

