/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.rule.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.archguard.rule.common.CasingKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u00062\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002J&\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\r\u00a8\u0006\u000f"}, d2={"Lorg/archguard/rule/common/Casing;", "", "()V", "addCasingType", "", "multipleNaming", "", "", "", "key", "it", "checkNaming", "list", "", "Companion", "rule-core"})
public final class Casing {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Map<String, List<String>> checkNaming(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Map multipleNaming = new HashMap();
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            boolean isNeedToFlag = ((CharSequence)it).length() > 0 && !Companion.isflat(it);
            if (!isNeedToFlag) continue;
            if (Companion.IsPacal(it)) {
                this.addCasingType(multipleNaming, "pascal", it);
            }
            if (Companion.is-kebab(it)) {
                this.addCasingType(multipleNaming, "kebab", it);
            }
            if (Companion.IS-COBOL(it)) {
                this.addCasingType(multipleNaming, "cobol", it);
            }
            if (Companion.is_nake(it)) {
                this.addCasingType(multipleNaming, "snake", it);
            }
            if (Companion.IS_MACRO(it)) {
                this.addCasingType(multipleNaming, "macro", it);
            }
            if (!Companion.isCamel(it)) continue;
            this.addCasingType(multipleNaming, "camel", it);
        }
        return multipleNaming;
    }

    private final void addCasingType(Map<String, List<String>> multipleNaming, String key, String it) {
        List<String> camel = multipleNaming.getOrDefault(key, new ArrayList());
        camel.add(it);
        multipleNaming.put(key, camel);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lorg/archguard/rule/common/Casing$Companion;", "", "()V", "IS-COBOL", "", "s", "", "IS_MACRO", "IsPacal", "is-kebab", "isCamel", "is_nake", "isflat", "rule-core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean IS-COBOL(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return CasingKt.getCOBOL_CASING().matches((CharSequence)s);
        }

        public final boolean isflat(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return CasingKt.getFLAT_CASING().matches((CharSequence)s);
        }

        public final boolean IsPacal(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return CasingKt.getPASCAL_CASING().matches((CharSequence)s);
        }

        public final boolean is-kebab(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return CasingKt.getKEBAB_CASING().matches((CharSequence)s);
        }

        public final boolean is_nake(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return CasingKt.getSNAKE_CASING().matches((CharSequence)s);
        }

        public final boolean IS_MACRO(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return CasingKt.getMACRO_CASING().matches((CharSequence)s);
        }

        public final boolean isCamel(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return CasingKt.getCAMEL_CASING().matches((CharSequence)s);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

