/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.core.sourcecode;

import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeFunction;
import chapi.domain.core.CodePosition;
import java.io.File;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.archguard.scanner.core.sourcecode.LanguageSourceCodeAnalyser;
import org.archguard.scanner.core.sourcecode.SourceCodeAnalyser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&J\u001a\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0016J\u001e\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J,\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00032\u0006\u0010\u0011\u001a\u00020\b2\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\f\u0010\u0015\u001a\u00020\b*\u00020\u0010H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/archguard/scanner/core/sourcecode/LanguageSourceCodeAnalyser;", "Lorg/archguard/scanner/core/sourcecode/SourceCodeAnalyser;", "analyse", "", "Lchapi/domain/core/CodeDataStruct;", "", "input", "contentByPosition", "", "lines", "position", "Lchapi/domain/core/CodePosition;", "display", "function", "Lchapi/domain/core/CodeFunction;", "getFilesByPath", "Ljava/io/File;", "path", "predicate", "Lkotlin/Function1;", "", "readContent", "Companion", "scanner_core"})
public interface LanguageSourceCodeAnalyser
extends SourceCodeAnalyser {
    @NotNull
    public static final Companion Companion = org.archguard.scanner.core.sourcecode.LanguageSourceCodeAnalyser$Companion.$$INSTANCE;

    @Override
    @Nullable
    public List<Object> analyse(@Nullable Object var1);

    @NotNull
    public List<CodeDataStruct> analyse();

    @NotNull
    public List<File> getFilesByPath(@NotNull String var1, @NotNull Function1<? super File, Boolean> var2);

    @NotNull
    public String readContent(@NotNull File var1);

    @NotNull
    public String display(@NotNull CodeFunction var1);

    @NotNull
    public String contentByPosition(@NotNull List<String> var1, @NotNull CodePosition var2);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/archguard/scanner/core/sourcecode/LanguageSourceCodeAnalyser$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "scanner_core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        private static final Logger logger;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
            logger = LoggerFactory.getLogger(LanguageSourceCodeAnalyser.class);
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Nullable
        public static List<Object> analyse(@NotNull LanguageSourceCodeAnalyser $this, @Nullable Object input) {
            return $this.analyse();
        }

        @NotNull
        public static List<File> getFilesByPath(@NotNull LanguageSourceCodeAnalyser $this, @NotNull String path, @NotNull Function1<? super File, Boolean> predicate) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Stream<Object> stream = ((Stream)StreamsKt.asStream((Sequence)((Sequence)FilesKt.walk$default((File)new File(path), null, (int)1, null))).parallel()).filter(arg_0 -> DefaultImpls.getFilesByPath$lambda$0(getFilesByPath.2.INSTANCE, arg_0)).filter(arg_0 -> DefaultImpls.getFilesByPath$lambda$1((Function1)new Function1<File, Boolean>(predicate){
                final /* synthetic */ Function1<File, Boolean> $predicate;
                {
                    this.$predicate = $predicate;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(File it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return (Boolean)this.$predicate.invoke((Object)it);
                }
            }, arg_0));
            Intrinsics.checkNotNullExpressionValue(stream, (String)"predicate: (File) -> Boo\u2026.filter { predicate(it) }");
            return StreamsKt.toList(stream);
        }

        public static /* synthetic */ List getFilesByPath$default(LanguageSourceCodeAnalyser languageSourceCodeAnalyser, String string, Function1 function1, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getFilesByPath");
            }
            if ((n & 2) != 0) {
                function1 = getFilesByPath.1.INSTANCE;
            }
            return languageSourceCodeAnalyser.getFilesByPath(string, (Function1<? super File, Boolean>)function1);
        }

        @NotNull
        public static String readContent(@NotNull LanguageSourceCodeAnalyser $this, @NotNull File $receiver) {
            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
            String text = FilesKt.readText$default((File)$receiver, null, (int)1, null);
            if (StringsKt.startsWith$default((String)text, (String)"\ufeff", (boolean)false, (int)2, null)) {
                String string = text.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                return string;
            }
            return text;
        }

        @NotNull
        public static String display(@NotNull LanguageSourceCodeAnalyser $this, @NotNull CodeFunction function) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            String annotation2 = CollectionsKt.joinToString$default((Iterable)function.getAnnotations(), (CharSequence)"\n", null, null, (int)0, null, (Function1)display.annotation.1.INSTANCE, (int)30, null);
            String params2 = CollectionsKt.joinToString$default((Iterable)function.getParameters(), (CharSequence)", ", null, null, (int)0, null, (Function1)display.params.1.INSTANCE, (int)30, null);
            String returnType = function.getReturnType();
            String body2 = CollectionsKt.joinToString$default((Iterable)function.getFunctionCalls(), (CharSequence)"\n", null, null, (int)0, null, (Function1)display.body.1.INSTANCE, (int)30, null);
            return StringsKt.trimIndent((String)("\n            " + annotation2 + "\n            " + function.getName() + '(' + params2 + ") -> " + returnType + " {\n                " + body2 + "\n            }\n        "));
        }

        @NotNull
        public static String contentByPosition(@NotNull LanguageSourceCodeAnalyser $this, @NotNull List<String> lines, @NotNull CodePosition position) {
            int startColumn;
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            int startLine = position.getStartLine() == 0 ? 0 : position.getStartLine() - 1;
            int endLine = position.getStopLine() == 0 ? 0 : position.getStopLine() - 1;
            String startLineContent = lines.get(startLine);
            String endLineContent = lines.get(endLine);
            int n = position.getStartLinePosition() > startLineContent.length() ? (StringsKt.isBlank((CharSequence)startLineContent) ? 0 : startLineContent.length() - 1) : (startColumn = position.getStartLinePosition());
            int endColumn = position.getStopLinePosition() > endLineContent.length() ? (StringsKt.isBlank((CharSequence)endLineContent) ? 0 : endLineContent.length() - 1) : position.getStopLinePosition();
            String string = startLineContent.substring(startColumn);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String start = string;
            String string2 = endLineContent.substring(0, endColumn);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String end = string2;
            return startLine == endLine ? start : start + CollectionsKt.joinToString$default((Iterable)lines.subList(startLine + 1, endLine), (CharSequence)"", null, null, (int)0, null, null, (int)62, null) + end;
        }

        private static boolean getFilesByPath$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }

        private static boolean getFilesByPath$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

