/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.diffchanges;

import chapi.ast.javaast.JavaAnalyser;
import chapi.ast.kotlinast.KotlinAnalyser;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeFunction;
import chapi.parser.ParseMode;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.archguard.scanner.analyser.diffchanges.ChangedEntry;
import org.archguard.scanner.analyser.diffchanges.DifferFile;
import org.archguard.scanner.core.diffchanges.ChangedCall;
import org.archguard.scanner.core.diffchanges.NodeRelationBuilder;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\tH\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170\t2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003J\u001e\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020%H\u0002J.\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\t2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020%2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0003H\u0002J\u0018\u0010+\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0014\u0010-\u001a\u00020.*\u00020.2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0014\u0010/\u001a\u000200*\u0002002\u0006\u0010\u0004\u001a\u00020\u0003H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\f\u00a8\u00061"}, d2={"Lorg/archguard/scanner/analyser/diffchanges/GitDiffer;", "Lorg/archguard/scanner/core/diffchanges/NodeRelationBuilder;", "path", "", "branch", "loopDepth", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "baseLineDataTree", "", "Lorg/archguard/scanner/analyser/diffchanges/DifferFile;", "getBranch", "()Ljava/lang/String;", "changedClasses", "", "Lorg/archguard/scanner/analyser/diffchanges/ChangedEntry;", "changedFiles", "changedFunctions", "differFileMap", "getLoopDepth", "()I", "getPath", "calculateChange", "Lorg/archguard/scanner/core/diffchanges/ChangedCall;", "compareWithBaseline", "", "diffEntry", "Lorg/eclipse/jgit/diff/DiffEntry;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "revCommit", "Lorg/eclipse/jgit/revwalk/RevCommit;", "countBetween", "sinceRev", "untilRev", "createBaselineAstTree", "since", "Lorg/eclipse/jgit/lib/ObjectId;", "diffFileFromBlob", "Lchapi/domain/core/CodeDataStruct;", "blobId", "pathString", "extension", "getChangedFiles", "getParent", "config", "Lorg/eclipse/jgit/diff/DiffFormatter;", "specifyBranch", "Lorg/eclipse/jgit/api/Git;", "analyser_diff_changes"})
@SourceDebugExtension(value={"SMAP\nGitDiffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitDiffer.kt\norg/archguard/scanner/analyser/diffchanges/GitDiffer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n1855#2,2:232\n1855#2,2:234\n1549#2:240\n1620#2,3:241\n819#2:244\n847#2,2:245\n1855#2,2:247\n1864#2,2:249\n819#2:251\n847#2,2:252\n1855#2,2:254\n1866#2:256\n1549#2:257\n1620#2,2:258\n1622#2:261\n1549#2:262\n1620#2,3:263\n1549#2:266\n1620#2,3:267\n1549#2:270\n1620#2,3:271\n125#3:236\n152#3,3:237\n1#4:260\n*S KotlinDebug\n*F\n+ 1 GitDiffer.kt\norg/archguard/scanner/analyser/diffchanges/GitDiffer\n*L\n63#1:232,2\n64#1:234,2\n91#1:240\n91#1:241,3\n116#1:244\n116#1:245,2\n117#1:247,2\n122#1:249,2\n132#1:251\n132#1:252,2\n133#1:254,2\n122#1:256\n208#1:257\n208#1:258,2\n208#1:261\n215#1:262\n215#1:263,3\n217#1:266\n217#1:267,3\n219#1:270\n219#1:271,3\n74#1:236\n74#1:237,3\n*E\n"})
public final class GitDiffer
extends NodeRelationBuilder {
    @NotNull
    private final String path;
    @NotNull
    private final String branch;
    private final int loopDepth;
    @NotNull
    private List<DifferFile> baseLineDataTree;
    @NotNull
    private final Map<String, DifferFile> differFileMap;
    @NotNull
    private final Map<String, ChangedEntry> changedFiles;
    @NotNull
    private final Map<String, ChangedEntry> changedClasses;
    @NotNull
    private final Map<String, ChangedEntry> changedFunctions;

    public GitDiffer(@NotNull String path, @NotNull String branch, int loopDepth) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        this.path = path;
        this.branch = branch;
        this.loopDepth = loopDepth;
        this.baseLineDataTree = CollectionsKt.emptyList();
        this.differFileMap = new LinkedHashMap();
        this.changedFiles = new LinkedHashMap();
        this.changedClasses = new LinkedHashMap();
        this.changedFunctions = new LinkedHashMap();
    }

    public /* synthetic */ GitDiffer(String string, String string2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 7;
        }
        this(string, string2, n);
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final String getBranch() {
        return this.branch;
    }

    public final int getLoopDepth() {
        return this.loopDepth;
    }

    @NotNull
    public final List<ChangedCall> countBetween(@NotNull String sinceRev, @NotNull String untilRev) {
        DifferFile file;
        Intrinsics.checkNotNullParameter((Object)sinceRev, (String)"sinceRev");
        Intrinsics.checkNotNullParameter((Object)untilRev, (String)"untilRev");
        Repository repository = ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(new File(this.path))).build();
        Git git = this.specifyBranch(new Git(repository), this.branch);
        ObjectId objectId = git.getRepository().resolve(sinceRev);
        Intrinsics.checkNotNullExpressionValue((Object)objectId, (String)"git.repository.resolve(sinceRev)");
        ObjectId since = objectId;
        ObjectId objectId2 = git.getRepository().resolve(untilRev);
        Intrinsics.checkNotNullExpressionValue((Object)objectId2, (String)"git.repository.resolve(untilRev)");
        ObjectId until = objectId2;
        Intrinsics.checkNotNullExpressionValue((Object)repository, (String)"repository");
        this.baseLineDataTree = this.createBaselineAstTree(repository, since);
        for (RevCommit commit : git.log().addRange((AnyObjectId)since, (AnyObjectId)until).call()) {
            Intrinsics.checkNotNullExpressionValue((Object)commit, (String)"commit");
            this.getChangedFiles(repository, commit);
        }
        Iterable $this$forEach$iv = this.baseLineDataTree;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            file = (DifferFile)element$iv;
            boolean bl = false;
            this.fillFunctionMap(file.getDataStructs());
        }
        $this$forEach$iv = this.baseLineDataTree;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            file = (DifferFile)element$iv;
            boolean bl = false;
            this.fillReverseCallMap(file.getDataStructs());
        }
        List<ChangedCall> changedCalls = this.calculateChange();
        return changedCalls;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ChangedCall> calculateChange() {
        void $this$mapTo$iv$iv;
        Map<String, ChangedEntry> $this$map$iv = this.changedFunctions;
        boolean $i$f$map = false;
        Map<String, ChangedEntry> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            List nodeRelations;
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String callName = ((ChangedEntry)it.getValue()).getPackageName() + '.' + ((ChangedEntry)it.getValue()).getClassName() + '.' + ((ChangedEntry)it.getValue()).getFunctionName();
            List list = this.calculateReverseCalls(callName, nodeRelations = (List)new ArrayList(), this.loopDepth);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            collection.add(new ChangedCall(((ChangedEntry)it.getValue()).getPath(), ((ChangedEntry)it.getValue()).getPackageName(), ((ChangedEntry)it.getValue()).getClassName(), nodeRelations));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final void getChangedFiles(Repository repository, RevCommit revCommit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        DiffFormatter diffFormatter = this.config(new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE), repository);
        RevCommit revCommit2 = this.getParent(revCommit);
        List list = diffFormatter.scan((RevTree)(revCommit2 != null ? revCommit2.getTree() : null), revCommit.getTree());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"diffFormatter.scan(getPa\u2026t)?.tree, revCommit.tree)");
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void d;
            DiffEntry diffEntry = (DiffEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"d");
            this.compareWithBaseline((DiffEntry)d, repository, revCommit);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void compareWithBaseline(DiffEntry diffEntry, Repository repository, RevCommit revCommit) {
        TreeWalk treeWalk = TreeWalk.forPath((Repository)repository, (String)diffEntry.getNewPath(), (RevTree)revCommit.getTree());
        if (treeWalk == null) {
            return;
        }
        TreeWalk treeWalk2 = treeWalk;
        String filePath = treeWalk2.getPathString();
        ObjectId blobId = treeWalk2.getObjectId(0);
        List<CodeDataStruct> newDataStructs = null;
        String extension = FilesKt.getExtension((File)new File(filePath));
        Intrinsics.checkNotNullExpressionValue((Object)blobId, (String)"blobId");
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"filePath");
        newDataStructs = this.diffFileFromBlob(repository, blobId, filePath, extension);
        if (this.differFileMap.get(filePath) != null) {
            DifferFile differFile = this.differFileMap.get(filePath);
            Intrinsics.checkNotNull((Object)differFile);
            List<CodeDataStruct> oldDataStructs = differFile.getDataStructs();
            if (newDataStructs.size() != oldDataStructs.size()) {
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv = newDataStructs;
                boolean $i$f$filterNot = false;
                Iterable iterable = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    CodeDataStruct it = (CodeDataStruct)element$iv$iv;
                    boolean bl = false;
                    if (oldDataStructs.contains(it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List difference = (List)destination$iv$iv;
                Iterable $this$forEach$iv = difference;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CodeDataStruct it = (CodeDataStruct)element$iv;
                    boolean bl = false;
                    this.changedFiles.put(filePath, new ChangedEntry(filePath, filePath, it.getPackage(), it.getNodeName(), null, 16, null));
                }
            } else {
                Iterable $this$forEachIndexed$iv = newDataStructs;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void $this$filterNotTo$iv$iv;
                    void ds;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    CodeDataStruct bl = (CodeDataStruct)item$iv;
                    int index = n;
                    boolean bl2 = false;
                    if (ds.getFields().size() != oldDataStructs.get(index).getFields().size()) {
                        this.changedClasses.put(filePath, new ChangedEntry(filePath, filePath, ds.getPackage(), ds.getNodeName(), null, 16, null));
                    } else if (!Intrinsics.areEqual((Object)ds.getFields(), (Object)oldDataStructs.get(index).getFields())) {
                        this.changedClasses.put(filePath, new ChangedEntry(filePath, filePath, ds.getPackage(), ds.getNodeName(), null, 16, null));
                    }
                    if (Intrinsics.areEqual((Object)ds.getFunctions(), (Object)oldDataStructs.get(index).getFunctions())) continue;
                    Iterable $this$filterNot$iv = ds.getFunctions();
                    boolean $i$f$filterNot = false;
                    Iterable iterable = $this$filterNot$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterNotTo = false;
                    for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                        CodeFunction it = (CodeFunction)element$iv$iv;
                        boolean bl3 = false;
                        if (oldDataStructs.get(index).getFunctions().contains(it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List difference = (List)destination$iv$iv;
                    Iterable $this$forEach$iv = difference;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        CodeFunction it = (CodeFunction)element$iv;
                        boolean bl4 = false;
                        this.changedFunctions.put(filePath, new ChangedEntry(filePath, filePath, ds.getPackage(), ds.getNodeName(), it.getName()));
                    }
                }
            }
        }
    }

    private final DiffFormatter config(DiffFormatter $this$config, Repository repository) {
        $this$config.setRepository(repository);
        $this$config.setDiffComparator(RawTextComparator.DEFAULT);
        $this$config.setDetectRenames(true);
        return $this$config;
    }

    private final RevCommit getParent(RevCommit revCommit) {
        return revCommit.getParentCount() == 0 ? null : revCommit.getParent(0);
    }

    private final List<DifferFile> createBaselineAstTree(Repository repository, ObjectId since) {
        RevWalk rw = new RevWalk(repository);
        TreeWalk tw = new TreeWalk(repository);
        RevCommit revCommit = rw.parseCommit((AnyObjectId)since);
        Intrinsics.checkNotNullExpressionValue((Object)revCommit, (String)"rw.parseCommit(since)");
        RevCommit commitToCheck = revCommit;
        tw.addTree((AnyObjectId)commitToCheck.getTree());
        tw.addTree((AbstractTreeIterator)new DirCacheIterator(repository.readDirCache()));
        tw.addTree((AbstractTreeIterator)new FileTreeIterator(repository));
        tw.setRecursive(true);
        List files = new ArrayList();
        while (tw.next()) {
            try {
                ObjectId blobId;
                String pathString = tw.getPathString();
                Intrinsics.checkNotNullExpressionValue((Object)tw.getObjectId(0), (String)"tw.getObjectId(0)");
                String extension = FilesKt.getExtension((File)new File(pathString));
                Intrinsics.checkNotNullExpressionValue((Object)pathString, (String)"pathString");
                List<CodeDataStruct> dataStructs = this.diffFileFromBlob(repository, blobId, pathString, extension);
                DifferFile differFile = new DifferFile(pathString, dataStructs);
                this.differFileMap.put(pathString, differFile);
                ((Collection)files).add(differFile);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final List<CodeDataStruct> diffFileFromBlob(Repository repository, ObjectId blobId, String pathString, String extension) {
        block16: {
            fileName = new File(pathString).getName();
            var7_6 = (AutoCloseable)repository.newObjectReader();
            var8_7 = null;
            try {
                objectReader /* !! */  = (ObjectReader)var7_6;
                $i$a$-use-GitDiffer$diffFileFromBlob$content$1 = false;
                v0 = objectReader /* !! */ .open((AnyObjectId)blobId).getBytes();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"objectReader.open(blobId).bytes");
                var11_14 = v0;
                v1 = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"UTF_8");
                var12_16 = v1;
                objectReader /* !! */  = new String(var11_14, var12_16);
            }
            catch (Throwable objectReader) {
                var8_7 = objectReader;
                throw objectReader;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)var7_6, (Throwable)var8_7);
            }
            content /* !! */  = objectReader /* !! */ ;
            var7_6 = extension;
            switch (var7_6.hashCode()) {
                case 3254818: {
                    if (var7_6.equals("java")) break;
                    ** break;
                }
                case 3433: {
                    if (!var7_6.equals("kt")) {
                        ** break;
                    }
                    ** GOTO lbl36
                }
                case 106538: {
                    if (!var7_6.equals("kts")) ** break;
lbl36:
                    // 2 sources

                    analyser = new KotlinAnalyser();
                    Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
                    $this$diffFileFromBlob_u24lambda_u2412 = analyser.analysis((String)content /* !! */ , fileName, ParseMode.Full);
                    $i$a$-run-GitDiffer$diffFileFromBlob$1 = false;
                    $this$map$iv = $this$diffFileFromBlob_u24lambda_u2412.getDataStructures();
                    $i$f$map = false;
                    var14_23 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var19_38 = (CodeDataStruct)item$iv$iv;
                        var20_42 = destination$iv$iv;
                        $i$a$-map-GitDiffer$diffFileFromBlob$1$1 = false;
                        $this$diffFileFromBlob_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410 = var22_46 = it;
                        $i$a$-apply-GitDiffer$diffFileFromBlob$1$1$1 = false;
                        it.setFilePath(pathString);
                        var20_42.add(var22_46);
                    }
                    v2 = (List)destination$iv$iv;
                    break block16;
                }
            }
            analyser = new JavaAnalyser();
            Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
            $this$diffFileFromBlob_u24lambda_u2415 = analyser.identBasicInfo((String)content /* !! */ , fileName);
            $i$a$-run-GitDiffer$diffFileFromBlob$basicNodes$1 = false;
            $this$map$iv = $this$diffFileFromBlob_u24lambda_u2415.getDataStructures();
            $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var20_43 = (CodeDataStruct)item$iv$iv;
                $i$a$-map-GitDiffer$diffFileFromBlob$1$1 = destination$iv$iv;
                $i$a$-map-GitDiffer$diffFileFromBlob$basicNodes$1$1 = false;
                $this$diffFileFromBlob_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413 = $this$diffFileFromBlob_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410 = ds;
                $i$a$-apply-GitDiffer$diffFileFromBlob$basicNodes$1$1$1 = false;
                ds.setImports($this$diffFileFromBlob_u24lambda_u2415_u24lambda_u2414_u24lambda_u2413.getImports());
                $i$a$-map-GitDiffer$diffFileFromBlob$1$1.add($this$diffFileFromBlob_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410);
            }
            basicNodes = (List)destination$iv$iv;
            $this$map$iv = basicNodes;
            $i$f$map = false;
            $this$map$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (E item$iv$iv : $this$mapTo$iv$iv) {
                item$iv$iv = (CodeDataStruct)item$iv$iv;
                var27_56 = destination$iv$iv;
                $i$a$-map-GitDiffer$diffFileFromBlob$classes$1 = false;
                var27_56.add(it.getClassFullName());
            }
            classes = (List)destination$iv$iv;
            $this$diffFileFromBlob_u24lambda_u2419 = analyser.identFullInfo((String)content /* !! */ , fileName, classes, basicNodes);
            $i$a$-run-GitDiffer$diffFileFromBlob$2 = false;
            $this$map$iv = $this$diffFileFromBlob_u24lambda_u2419.getDataStructures();
            $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                $i$a$-map-GitDiffer$diffFileFromBlob$1$1 = (CodeDataStruct)item$iv$iv;
                var22_48 = destination$iv$iv;
                $i$a$-map-GitDiffer$diffFileFromBlob$2$1 = false;
                $this$diffFileFromBlob_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417 = var24_53 = ds;
                $i$a$-apply-GitDiffer$diffFileFromBlob$2$1$1 = false;
                ds.setImports($this$diffFileFromBlob_u24lambda_u2419_u24lambda_u2418_u24lambda_u2417.getImports());
                var22_48.add(var24_53);
            }
            v2 = (List)destination$iv$iv;
            break block16;
lbl118:
            // 4 sources

            v2 = CollectionsKt.emptyList();
        }
        return v2;
    }

    private final Git specifyBranch(Git $this$specifyBranch, String branch) {
        Git git;
        Git $this$specifyBranch_u24lambda_u2420 = git = $this$specifyBranch;
        boolean bl = false;
        $this$specifyBranch_u24lambda_u2420.checkout().setName(branch).call();
        return git;
    }
}

