/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.diffchanges;

import chapi.ast.javaast.JavaAnalyser;
import chapi.ast.kotlinast.AnalysisMode;
import chapi.ast.kotlinast.KotlinAnalyser;
import chapi.domain.core.CodeCall;
import chapi.domain.core.CodeContainer;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeField;
import chapi.domain.core.CodeFunction;
import java.io.File;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.archguard.scanner.analyser.diffchanges.ChangedEntry;
import org.archguard.scanner.analyser.diffchanges.DifferFile;
import org.archguard.scanner.core.diffchanges.ChangeRelation;
import org.archguard.scanner.core.diffchanges.ChangedCall;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.FileTreeIterator;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.util.io.DisabledOutputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\tJ.\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\t2\u0006\u0010 \u001a\u00020\u00032\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u001c\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001d0\t2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003J\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010&\u001a\u00020'2\u0006\u0010.\u001a\u00020/H\u0002J3\u00100\u001a\b\u0012\u0004\u0012\u000202012\u0006\u0010&\u001a\u00020'2\u0006\u00103\u001a\u00020/2\u0006\u00104\u001a\u00020\u00032\u0006\u00105\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u00106J\u0006\u00107\u001a\u00020#J\u0006\u00108\u001a\u00020#J\u0018\u00109\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0012\u0010:\u001a\u0004\u0018\u00010)2\u0006\u0010(\u001a\u00020)H\u0002J\u0014\u0010;\u001a\u00020<*\u00020<2\u0006\u0010&\u001a\u00020'H\u0002J\u0014\u0010=\u001a\u00020>*\u00020>2\u0006\u0010\u0004\u001a\u00020\u0003H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00140\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\fR \u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/archguard/scanner/analyser/diffchanges/GitDiffer;", "", "path", "", "branch", "loopDepth", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "baseLineDataTree", "", "Lorg/archguard/scanner/analyser/diffchanges/DifferFile;", "getBranch", "()Ljava/lang/String;", "changedClasses", "", "Lorg/archguard/scanner/analyser/diffchanges/ChangedEntry;", "changedFiles", "changedFunctions", "differFileMap", "functionMap", "", "lastReverseCallChild", "loopCount", "getLoopDepth", "()I", "getPath", "reverseCallMap", "", "calculateChange", "Lorg/archguard/scanner/core/diffchanges/ChangedCall;", "calculateReverseCalls", "Lorg/archguard/scanner/core/diffchanges/ChangeRelation;", "funName", "changeRelations", "compareWithBaseline", "", "diffEntry", "Lorg/eclipse/jgit/diff/DiffEntry;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "revCommit", "Lorg/eclipse/jgit/revwalk/RevCommit;", "countBetween", "sinceRev", "untilRev", "createBaselineAstTree", "since", "Lorg/eclipse/jgit/lib/ObjectId;", "diffFileFromBlob", "", "Lchapi/domain/core/CodeDataStruct;", "blobId", "pathString", "extension", "(Lorg/eclipse/jgit/lib/Repository;Lorg/eclipse/jgit/lib/ObjectId;Ljava/lang/String;Ljava/lang/String;)[Lchapi/domain/core/CodeDataStruct;", "genFunctionCallMap", "genFunctionMap", "getChangedFiles", "getParent", "config", "Lorg/eclipse/jgit/diff/DiffFormatter;", "specifyBranch", "Lorg/eclipse/jgit/api/Git;", "analyser_diff_changes"})
public final class GitDiffer {
    @NotNull
    private final String path;
    @NotNull
    private final String branch;
    private final int loopDepth;
    @NotNull
    private List<DifferFile> baseLineDataTree;
    @NotNull
    private final Map<String, DifferFile> differFileMap;
    @NotNull
    private final Map<String, ChangedEntry> changedFiles;
    @NotNull
    private final Map<String, ChangedEntry> changedClasses;
    @NotNull
    private final Map<String, ChangedEntry> changedFunctions;
    private int loopCount;
    @NotNull
    private String lastReverseCallChild;
    @NotNull
    private final Map<String, Boolean> functionMap;
    @NotNull
    private final Map<String, List<String>> reverseCallMap;

    public GitDiffer(@NotNull String path, @NotNull String branch, int loopDepth) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        this.path = path;
        this.branch = branch;
        this.loopDepth = loopDepth;
        this.baseLineDataTree = CollectionsKt.emptyList();
        this.differFileMap = new LinkedHashMap();
        this.changedFiles = new LinkedHashMap();
        this.changedClasses = new LinkedHashMap();
        this.changedFunctions = new LinkedHashMap();
        this.lastReverseCallChild = "";
        this.functionMap = new LinkedHashMap();
        this.reverseCallMap = new LinkedHashMap();
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @NotNull
    public final String getBranch() {
        return this.branch;
    }

    public final int getLoopDepth() {
        return this.loopDepth;
    }

    @NotNull
    public final List<ChangedCall> countBetween(@NotNull String sinceRev, @NotNull String untilRev) {
        Intrinsics.checkNotNullParameter((Object)sinceRev, (String)"sinceRev");
        Intrinsics.checkNotNullParameter((Object)untilRev, (String)"untilRev");
        Repository repository = ((FileRepositoryBuilder)new FileRepositoryBuilder().findGitDir(new File(this.path))).build();
        Git git = this.specifyBranch(new Git(repository), this.branch);
        ObjectId objectId = git.getRepository().resolve(sinceRev);
        Intrinsics.checkNotNullExpressionValue((Object)objectId, (String)"git.repository.resolve(sinceRev)");
        ObjectId since = objectId;
        ObjectId objectId2 = git.getRepository().resolve(untilRev);
        Intrinsics.checkNotNullExpressionValue((Object)objectId2, (String)"git.repository.resolve(untilRev)");
        ObjectId until = objectId2;
        Intrinsics.checkNotNullExpressionValue((Object)repository, (String)"repository");
        this.baseLineDataTree = this.createBaselineAstTree(repository, since);
        for (RevCommit commit : git.log().addRange((AnyObjectId)since, (AnyObjectId)until).call()) {
            Intrinsics.checkNotNullExpressionValue((Object)commit, (String)"commit");
            this.getChangedFiles(repository, commit);
        }
        this.genFunctionMap();
        this.genFunctionCallMap();
        List<ChangedCall> changedCalls = this.calculateChange();
        return changedCalls;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ChangedCall> calculateChange() {
        void $this$mapTo$iv$iv;
        Map<String, ChangedEntry> $this$map$iv = this.changedFunctions;
        boolean $i$f$map = false;
        Map<String, ChangedEntry> map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            List changeRelations;
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String callName = ((ChangedEntry)it.getValue()).getPackageName() + '.' + ((ChangedEntry)it.getValue()).getClassName() + '.' + ((ChangedEntry)it.getValue()).getFunctionName();
            List list = this.calculateReverseCalls(callName, changeRelations = (List)new ArrayList(), this.loopDepth);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            collection.add(new ChangedCall(((ChangedEntry)it.getValue()).getPath(), ((ChangedEntry)it.getValue()).getPackageName(), ((ChangedEntry)it.getValue()).getClassName(), changeRelations));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final List<ChangeRelation> calculateReverseCalls(String funName, List<ChangeRelation> changeRelations, int loopDepth) {
        block5: {
            List<String> calls;
            if (this.loopCount > loopDepth) {
                return null;
            }
            int n = this.loopCount;
            this.loopCount = n + 1;
            List<String> list = calls = this.reverseCallMap.get(funName);
            if (list == null) break block5;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String child = (String)element$iv;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)child, (Object)this.lastReverseCallChild)) {
                    return null;
                }
                if (this.reverseCallMap.get(child) != null) {
                    this.lastReverseCallChild = child;
                    List<ChangeRelation> optRelations = this.calculateReverseCalls(child, changeRelations, loopDepth);
                    if (optRelations != null) {
                        CollectionsKt.addAll((Collection)changeRelations, (Iterable)optRelations);
                    }
                }
                if (Intrinsics.areEqual((Object)child, (Object)funName)) continue;
                ((Collection)changeRelations).add(new ChangeRelation(child, funName));
            }
        }
        return null;
    }

    public final void genFunctionMap() {
        Iterable $this$forEach$iv = this.baseLineDataTree;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DifferFile file = (DifferFile)element$iv;
            boolean bl = false;
            CodeDataStruct[] $this$forEach$iv2 = file.getDataStructs();
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                CodeDataStruct element$iv2;
                CodeDataStruct node = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                CodeFunction[] $this$forEach$iv3 = node.getFunctions();
                boolean $i$f$forEach3 = false;
                int n2 = $this$forEach$iv3.length;
                for (int j = 0; j < n2; ++j) {
                    CodeFunction element$iv3;
                    CodeFunction it = element$iv3 = $this$forEach$iv3[j];
                    boolean bl3 = false;
                    this.functionMap.put(node.getPackage() + '.' + node.getNodeName() + '.' + it.getName(), true);
                }
            }
        }
    }

    public final void genFunctionCallMap() {
        Iterable $this$forEach$iv = this.baseLineDataTree;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DifferFile file = (DifferFile)element$iv;
            boolean bl = false;
            CodeDataStruct[] $this$forEach$iv2 = file.getDataStructs();
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                int n2;
                CodeField it;
                CodeField element$iv2;
                int n3;
                CodeDataStruct element$iv3;
                CodeDataStruct node = element$iv3 = $this$forEach$iv2[i];
                boolean bl2 = false;
                CodeField[] $this$forEach$iv3 = node.getFields();
                boolean $i$f$forEach3 = false;
                int n4 = $this$forEach$iv3.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    it = element$iv2 = $this$forEach$iv3[n3];
                    boolean bl3 = false;
                    CodeCall[] $this$forEach$iv4 = it.getCalls();
                    boolean $i$f$forEach4 = false;
                    n2 = $this$forEach$iv4.length;
                    for (int j = 0; j < n2; ++j) {
                        CodeCall element$iv4;
                        CodeCall it2 = element$iv4 = $this$forEach$iv4[j];
                        boolean bl4 = false;
                    }
                }
                $this$forEach$iv3 = node.getFunctions();
                $i$f$forEach3 = false;
                n4 = $this$forEach$iv3.length;
                for (n3 = 0; n3 < n4; ++n3) {
                    it = element$iv2 = $this$forEach$iv3[n3];
                    boolean bl5 = false;
                    String caller = node.getPackage() + '.' + node.getNodeName() + '.' + it.getName();
                    CodeCall[] $this$forEach$iv5 = it.getFunctionCalls();
                    boolean $i$f$forEach5 = false;
                    int n5 = $this$forEach$iv5.length;
                    for (n2 = 0; n2 < n5; ++n2) {
                        CodeCall element$iv5;
                        CodeCall codeCall = element$iv5 = $this$forEach$iv5[n2];
                        boolean bl6 = false;
                        String callee = codeCall.buildFullMethodName();
                        if (this.functionMap.get(callee) == null) continue;
                        if (this.reverseCallMap.get(callee) == null) {
                            this.reverseCallMap.put(callee, new ArrayList());
                        }
                        List<String> list = this.reverseCallMap.get(callee);
                        Intrinsics.checkNotNull(list);
                        ((Collection)list).add(caller);
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void getChangedFiles(Repository repository, RevCommit revCommit) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        DiffFormatter diffFormatter = this.config(new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE), repository);
        RevCommit revCommit2 = this.getParent(revCommit);
        List list = diffFormatter.scan((RevTree)(revCommit2 != null ? revCommit2.getTree() : null), revCommit.getTree());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"diffFormatter.scan(getPa\u2026t)?.tree, revCommit.tree)");
        Iterable iterable = list;
        boolean $i$f$map = false;
        void var6_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void d;
            DiffEntry diffEntry = (DiffEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)d, (String)"d");
            this.compareWithBaseline((DiffEntry)d, repository, revCommit);
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void compareWithBaseline(DiffEntry diffEntry, Repository repository, RevCommit revCommit) {
        TreeWalk treeWalk = TreeWalk.forPath((Repository)repository, (String)diffEntry.getNewPath(), (RevTree)revCommit.getTree());
        if (treeWalk == null) {
            return;
        }
        TreeWalk treeWalk2 = treeWalk;
        String filePath = treeWalk2.getPathString();
        ObjectId blobId = treeWalk2.getObjectId(0);
        CodeDataStruct[] newDataStructs = null;
        String extension = FilesKt.getExtension((File)new File(filePath));
        Intrinsics.checkNotNullExpressionValue((Object)blobId, (String)"blobId");
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"filePath");
        newDataStructs = this.diffFileFromBlob(repository, blobId, filePath, extension);
        if (this.differFileMap.get(filePath) != null) {
            DifferFile differFile = this.differFileMap.get(filePath);
            Intrinsics.checkNotNull((Object)differFile);
            Object[] oldDataStructs = differFile.getDataStructs();
            if (newDataStructs.length != oldDataStructs.length) {
                void $this$filterNotTo$iv$iv;
                CodeDataStruct[] $this$filterNot$iv = newDataStructs;
                boolean $i$f$filterNot = false;
                CodeDataStruct[] codeDataStructArray = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                int n = ((void)$this$filterNotTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterNotTo$iv$iv[i];
                    boolean bl = false;
                    if (ArraysKt.contains((Object[])oldDataStructs, (Object)it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List difference = (List)destination$iv$iv;
                Iterable $this$forEach$iv = difference;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    CodeDataStruct it = (CodeDataStruct)element$iv;
                    boolean bl = false;
                    this.changedFiles.put(filePath, new ChangedEntry(filePath, filePath, it.getPackage(), it.getNodeName(), null, 16, null));
                }
            } else {
                CodeDataStruct[] $this$forEachIndexed$iv = newDataStructs;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (CodeDataStruct item$iv : $this$forEachIndexed$iv) {
                    void $this$filterNotTo$iv$iv;
                    void ds;
                    int n = index$iv++;
                    CodeDataStruct bl = item$iv;
                    int index = n;
                    boolean bl2 = false;
                    if (ds.getFields().length != oldDataStructs[index].getFields().length) {
                        this.changedClasses.put(filePath, new ChangedEntry(filePath, filePath, ds.getPackage(), ds.getNodeName(), null, 16, null));
                    } else if (!Arrays.equals(ds.getFields(), oldDataStructs[index].getFields())) {
                        this.changedClasses.put(filePath, new ChangedEntry(filePath, filePath, ds.getPackage(), ds.getNodeName(), null, 16, null));
                    }
                    if (Arrays.equals(ds.getFunctions(), oldDataStructs[index].getFunctions())) continue;
                    CodeFunction[] $this$filterNot$iv = ds.getFunctions();
                    boolean $i$f$filterNot = false;
                    CodeFunction[] codeFunctionArray = $this$filterNot$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterNotTo = false;
                    int n2 = ((void)$this$filterNotTo$iv$iv).length;
                    for (int i = 0; i < n2; ++i) {
                        void element$iv$iv;
                        void it = element$iv$iv = $this$filterNotTo$iv$iv[i];
                        boolean bl3 = false;
                        if (ArraysKt.contains((Object[])oldDataStructs[index].getFunctions(), (Object)it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List difference = (List)destination$iv$iv;
                    Iterable $this$forEach$iv = difference;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        CodeFunction it = (CodeFunction)element$iv;
                        boolean bl4 = false;
                        this.changedFunctions.put(filePath, new ChangedEntry(filePath, filePath, ds.getPackage(), ds.getNodeName(), it.getName()));
                    }
                }
            }
        }
    }

    private final DiffFormatter config(DiffFormatter $this$config, Repository repository) {
        $this$config.setRepository(repository);
        $this$config.setDiffComparator(RawTextComparator.DEFAULT);
        $this$config.setDetectRenames(true);
        return $this$config;
    }

    private final RevCommit getParent(RevCommit revCommit) {
        return revCommit.getParentCount() == 0 ? (RevCommit)null : revCommit.getParent(0);
    }

    private final List<DifferFile> createBaselineAstTree(Repository repository, ObjectId since) {
        RevWalk rw = new RevWalk(repository);
        TreeWalk tw = new TreeWalk(repository);
        RevCommit revCommit = rw.parseCommit((AnyObjectId)since);
        Intrinsics.checkNotNullExpressionValue((Object)revCommit, (String)"rw.parseCommit(since)");
        RevCommit commitToCheck = revCommit;
        tw.addTree((AnyObjectId)commitToCheck.getTree());
        tw.addTree((AbstractTreeIterator)new DirCacheIterator(repository.readDirCache()));
        tw.addTree((AbstractTreeIterator)new FileTreeIterator(repository));
        tw.setRecursive(true);
        List files = new ArrayList();
        while (tw.next()) {
            try {
                ObjectId blobId;
                String pathString = tw.getPathString();
                Intrinsics.checkNotNullExpressionValue((Object)tw.getObjectId(0), (String)"tw.getObjectId(0)");
                String extension = FilesKt.getExtension((File)new File(pathString));
                Intrinsics.checkNotNullExpressionValue((Object)pathString, (String)"pathString");
                CodeDataStruct[] dataStructs = this.diffFileFromBlob(repository, blobId, pathString, extension);
                DifferFile differFile = new DifferFile(pathString, dataStructs);
                this.differFileMap.put(pathString, differFile);
                ((Collection)files).add(differFile);
            }
            catch (Exception e) {
                System.out.println(e);
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final CodeDataStruct[] diffFileFromBlob(Repository repository, ObjectId blobId, String pathString, String extension) {
        CodeDataStruct[] codeDataStructArray;
        KotlinAnalyser analyser;
        Object objectReader2;
        String fileName = new File(pathString).getName();
        Object object = (AutoCloseable)repository.newObjectReader();
        Throwable throwable = null;
        try {
            objectReader2 = (ObjectReader)object;
            boolean bl = false;
            byte[] byArray = objectReader2.open((AnyObjectId)blobId).getBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"objectReader.open(blobId).bytes");
            byte[] byArray2 = byArray;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Charset charset2 = charset;
            objectReader2 = new String(byArray2, charset2);
        }
        catch (Throwable objectReader2) {
            throwable = objectReader2;
            throw objectReader2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
        Object content = objectReader2;
        object = extension;
        if (Intrinsics.areEqual((Object)object, (Object)"kt")) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            analyser = new KotlinAnalyser();
            Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
            CodeContainer $this$diffFileFromBlob_u24lambda_u2d20 = analyser.analysis((String)content, fileName, AnalysisMode.Full);
            boolean bl = false;
            CodeDataStruct[] $this$map$iv = $this$diffFileFromBlob_u24lambda_u2d20.getDataStructures();
            boolean $i$f$map = false;
            CodeDataStruct[] codeDataStructArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void var23_61;
                void item$iv$iv4;
                void var20_53 = item$iv$iv4 = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                void $this$diffFileFromBlob_u24lambda_u2d20_u24lambda_u2d19_u24lambda_u2d18 = var23_61 = it;
                boolean bl3 = false;
                it.setFilePath(pathString);
                collection.add(var23_61);
            }
            objectReader2 = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            CodeDataStruct[] codeDataStructArray3 = thisCollection$iv.toArray(new CodeDataStruct[0]);
            if (codeDataStructArray3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            codeDataStructArray = codeDataStructArray3;
        } else if (Intrinsics.areEqual((Object)object, (Object)"java")) {
            void $this$mapTo$iv$iv;
            Collection $this$toTypedArray$iv;
            void $this$mapTo$iv$iv2;
            CodeDataStruct[] basicNodes;
            void $this$toTypedArray$iv2;
            Collection bl2;
            void $this$mapTo$iv$iv3;
            analyser = new JavaAnalyser();
            Intrinsics.checkNotNullExpressionValue((Object)fileName, (String)"fileName");
            CodeContainer $this$diffFileFromBlob_u24lambda_u2d23 = analyser.identBasicInfo((String)content, fileName);
            boolean bl = false;
            CodeDataStruct[] $this$map$iv = $this$diffFileFromBlob_u24lambda_u2d23.getDataStructures();
            boolean $i$f$map = false;
            CodeDataStruct[] destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv22 = new ArrayList($this$map$iv.length);
            int $i$f$mapTo = 0;
            int item$iv$iv4 = ((void)$this$mapTo$iv$iv3).length;
            for (int i = 0; i < item$iv$iv4; ++i) {
                void ds;
                void $this$diffFileFromBlob_u24lambda_u2d20_u24lambda_u2d19_u24lambda_u2d18;
                void item$iv$iv2;
                void var21_58 = item$iv$iv2 = $this$mapTo$iv$iv3[i];
                bl2 = destination$iv$iv22;
                boolean bl4 = false;
                void $this$diffFileFromBlob_u24lambda_u2d23_u24lambda_u2d22_u24lambda_u2d21 = $this$diffFileFromBlob_u24lambda_u2d20_u24lambda_u2d19_u24lambda_u2d18 = ds;
                boolean bl5 = false;
                ds.setImports($this$diffFileFromBlob_u24lambda_u2d23_u24lambda_u2d22_u24lambda_u2d21.getImports());
                bl2.add($this$diffFileFromBlob_u24lambda_u2d20_u24lambda_u2d19_u24lambda_u2d18);
            }
            Collection $i$f$toTypedArray = (List)destination$iv$iv22;
            boolean $i$f$toTypedArray2 = false;
            void thisCollection$iv = $this$toTypedArray$iv2;
            CodeDataStruct[] codeDataStructArray4 = thisCollection$iv.toArray(new CodeDataStruct[0]);
            if (codeDataStructArray4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            Object $this$map$iv2 = basicNodes = codeDataStructArray4;
            boolean $i$f$map2 = false;
            $this$map$iv = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(((CodeDataStruct[])$this$map$iv2).length);
            boolean $i$f$mapTo2 = false;
            $i$f$mapTo = ((void)$this$mapTo$iv$iv2).length;
            for (int destination$iv$iv22 = 0; destination$iv$iv22 < $i$f$mapTo; ++destination$iv$iv22) {
                void it;
                void item$iv$iv3;
                void item$iv$iv4 = item$iv$iv3 = $this$mapTo$iv$iv2[destination$iv$iv22];
                Collection collection = destination$iv$iv3;
                boolean bl6 = false;
                collection.add(it.getClassFullName());
            }
            $this$map$iv2 = (List)destination$iv$iv3;
            boolean $i$f$toTypedArray3 = false;
            void thisCollection$iv2 = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv2.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            String[] classes = stringArray;
            CodeContainer $this$diffFileFromBlob_u24lambda_u2d27 = analyser.identFullInfo((String)content, fileName, classes, basicNodes);
            boolean bl7 = false;
            CodeDataStruct[] $this$map$iv3 = $this$diffFileFromBlob_u24lambda_u2d27.getDataStructures();
            boolean $i$f$map3 = false;
            CodeDataStruct[] destination$iv$iv22 = $this$map$iv3;
            Collection destination$iv$iv4 = new ArrayList($this$map$iv3.length);
            boolean $i$f$mapTo3 = false;
            for (void item$iv$iv5 : $this$mapTo$iv$iv) {
                void ds;
                void var25_68;
                bl2 = item$iv$iv5;
                Collection collection = destination$iv$iv4;
                boolean bl8 = false;
                void $this$diffFileFromBlob_u24lambda_u2d27_u24lambda_u2d26_u24lambda_u2d25 = var25_68 = ds;
                boolean bl9 = false;
                ds.setImports($this$diffFileFromBlob_u24lambda_u2d27_u24lambda_u2d26_u24lambda_u2d25.getImports());
                collection.add(var25_68);
            }
            $this$toTypedArray$iv = (List)destination$iv$iv4;
            $i$f$toTypedArray = false;
            Collection thisCollection$iv22 = $this$toTypedArray$iv;
            CodeDataStruct[] codeDataStructArray5 = thisCollection$iv22.toArray(new CodeDataStruct[0]);
            if (codeDataStructArray5 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            codeDataStructArray = codeDataStructArray5;
        } else {
            boolean $i$f$emptyArray = false;
            codeDataStructArray = (CodeDataStruct[])((Object[])new CodeDataStruct[0]);
        }
        return codeDataStructArray;
    }

    private final Git specifyBranch(Git $this$specifyBranch, String branch) {
        Git git;
        Git $this$specifyBranch_u24lambda_u2d28 = git = $this$specifyBranch;
        boolean bl = false;
        $this$specifyBranch_u24lambda_u2d28.checkout().setName(branch).call();
        return git;
    }
}

