/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.architecture;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.archguard.architecture.ArchEstimateContext;
import org.archguard.architecture.ArchScaContext;
import org.archguard.architecture.ArchSourceCodeContext;
import org.archguard.architecture.ArchitectureView;
import org.archguard.architecture.core.Workspace;
import org.archguard.scanner.analyser.ApiCallAnalyser;
import org.archguard.scanner.analyser.EstimateAnalyser;
import org.archguard.scanner.analyser.JavaAnalyser;
import org.archguard.scanner.analyser.ScaAnalyser;
import org.archguard.scanner.core.architecture.ArchitectureContext;
import org.archguard.scanner.core.estimate.EstimateContext;
import org.archguard.scanner.core.sca.ScaContext;
import org.archguard.scanner.core.sourcecode.SourceCodeContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/archguard/architecture/ArchitectureAnalyser;", "Lorg/archguard/scanner/core/architecture/ArchitectureAnalyser;", "context", "Lorg/archguard/scanner/core/architecture/ArchitectureContext;", "(Lorg/archguard/scanner/core/architecture/ArchitectureContext;)V", "getContext", "()Lorg/archguard/scanner/core/architecture/ArchitectureContext;", "analyse", "", "Lorg/archguard/architecture/ArchitectureView;", "analyser_architecture"})
public final class ArchitectureAnalyser
implements org.archguard.scanner.core.architecture.ArchitectureAnalyser {
    @NotNull
    private final ArchitectureContext context;

    public ArchitectureAnalyser(@NotNull ArchitectureContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public ArchitectureContext getContext() {
        return this.context;
    }

    @NotNull
    public List<ArchitectureView> analyse() {
        ArchSourceCodeContext sourceCodeContext = new ArchSourceCodeContext("Java", null, null, this.getContext().getPath(), false, false, 54, null);
        List dataStructs = new JavaAnalyser((SourceCodeContext)sourceCodeContext).analyse();
        List projectDependencies = new ScaAnalyser((ScaContext)new ArchScaContext(this.getContext().getPath(), null, "java", 2, null)).analysisByPackages();
        List services = new ApiCallAnalyser((SourceCodeContext)sourceCodeContext).analyse(dataStructs);
        List languageEstimates = new EstimateAnalyser((EstimateContext)new ArchEstimateContext(this.getContext().getPath(), null, null, 6, null)).analyse();
        ArchitectureView workspace = new Workspace(dataStructs, projectDependencies, services, null, 8, null).analysis();
        workspace.getPhysicalStructure().setLanguageEstimate(languageEstimates);
        return CollectionsKt.listOf((Object)workspace);
    }
}

