/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.architecture;

import chapi.domain.core.CodeDataStruct;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.archguard.architecture.core.Workspace;
import org.archguard.architecture.detect.ArchitectureDetect;
import org.archguard.architecture.detect.PotentialExecArch;
import org.archguard.meta.Slot;
import org.archguard.scanner.core.git.GitLogs;
import org.archguard.scanner.core.sca.PackageDependencies;
import org.archguard.scanner.core.sourcecode.ContainerService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J \u0010\u001a\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u001b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0012\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\u00040\tj\u0002`\u001dH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/archguard/architecture/ArchitectureSlot;", "Lorg/archguard/meta/Slot;", "()V", "csName", "", "kotlin.jvm.PlatformType", "dsName", "glName", "material", "", "", "Lorg/archguard/meta/Materials;", "getMaterial", "()Ljava/util/List;", "setMaterial", "(Ljava/util/List;)V", "outClass", "getOutClass", "()Ljava/lang/String;", "setOutClass", "(Ljava/lang/String;)V", "pkgName", "workspace", "Lorg/archguard/architecture/core/Workspace;", "prepare", "items", "process", "Lorg/archguard/meta/OutputType;", "ticket", "Lorg/archguard/meta/Coin;", "analyser_architecture"})
public final class ArchitectureSlot
implements Slot {
    @NotNull
    private List<? extends Object> material = CollectionsKt.emptyList();
    @NotNull
    private String outClass;
    @NotNull
    private final Workspace workspace;
    private final String dsName;
    private final String pkgName;
    private final String csName;
    private final String glName;

    public ArchitectureSlot() {
        String string = PotentialExecArch.Companion.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"PotentialExecArch.Companion::class.java.name");
        this.outClass = string;
        this.workspace = new Workspace(null, null, null, null, 15, null);
        this.dsName = CodeDataStruct.class.getName();
        this.pkgName = PackageDependencies.class.getName();
        this.csName = ContainerService.class.getName();
        this.glName = GitLogs.class.getName();
    }

    @NotNull
    public List<Object> getMaterial() {
        return this.material;
    }

    public void setMaterial(@NotNull List<? extends Object> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.material = list;
    }

    @NotNull
    public String getOutClass() {
        return this.outClass;
    }

    public void setOutClass(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.outClass = string;
    }

    @NotNull
    public List<String> ticket() {
        Object[] objectArray = new String[]{this.dsName, this.pkgName, this.csName, this.glName};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public List<Object> prepare(@NotNull List<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public List<Object> process(@NotNull List<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        return CollectionsKt.listOf((Object)new ArchitectureDetect().identPotential(this.workspace));
    }

    public boolean flowable() {
        return Slot.DefaultImpls.flowable((Slot)this);
    }
}

