/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.architecture.detect;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.archguard.architecture.detect.LayeredChecker;
import org.archguard.architecture.detect.LayeredIdentifyKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/archguard/architecture/detect/DddLayeredChecker;", "Lorg/archguard/architecture/detect/LayeredChecker;", "()V", "hasApp", "", "hasDomain", "hasInfra", "hasInterfaces", "addToIdentify", "", "str", "", "canMarked", "analyser_architecture"})
public final class DddLayeredChecker
implements LayeredChecker {
    private boolean hasDomain;
    private boolean hasInfra;
    private boolean hasInterfaces;
    private boolean hasApp;

    @Override
    public void addToIdentify(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        String[] stringArray = new String[]{"."};
        List split = StringsKt.split$default((CharSequence)str, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (!this.hasDomain) {
            this.hasDomain = LayeredIdentifyKt.getDOMAIN().contains(CollectionsKt.last((List)split));
        }
        if (!this.hasInterfaces) {
            this.hasInterfaces = LayeredIdentifyKt.getCONTROLLERS().contains(CollectionsKt.last((List)split));
        }
        if (!this.hasInfra) {
            this.hasInfra = LayeredIdentifyKt.getINFRA().contains(CollectionsKt.last((List)split));
        }
        if (!this.hasApp) {
            this.hasApp = LayeredIdentifyKt.getAPPLICATION().contains(CollectionsKt.last((List)split));
        }
    }

    @Override
    public boolean canMarked() {
        return this.hasInterfaces && this.hasDomain && this.hasApp && this.hasInfra;
    }
}

