/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.architecture.detect;

import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeImport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.archguard.architecture.core.CodeStructureStyle;
import org.archguard.architecture.core.ConnectorType;
import org.archguard.architecture.core.Workspace;
import org.archguard.architecture.detect.FrameworkMarkup;
import org.archguard.architecture.detect.LayeredIdentify;
import org.archguard.architecture.detect.PotentialExecArch;
import org.archguard.scanner.core.sca.DependencyEntry;
import org.archguard.scanner.core.sca.PackageDependencies;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lorg/archguard/architecture/detect/ArchitectureDetect;", "", "()V", "fillArchFromSourceCode", "", "workspace", "Lorg/archguard/architecture/core/Workspace;", "execArch", "Lorg/archguard/architecture/detect/PotentialExecArch;", "identPotential", "inferenceExecArchByDependencies", "markup", "Lorg/archguard/architecture/detect/FrameworkMarkup;", "packageDeps", "Lorg/archguard/scanner/core/sca/PackageDependencies;", "analyser_architecture"})
public final class ArchitectureDetect {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PotentialExecArch identPotential(@NotNull Workspace workspace) {
        Object object;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        PotentialExecArch execArch = new PotentialExecArch(null, null, null, null, null, null, 63, null);
        FrameworkMarkup markup = FrameworkMarkup.Companion.byLanguage("Java");
        if (markup != null) {
            execArch = this.inferenceExecArchByDependencies(markup, workspace.getProjectDependencies());
        }
        this.fillArchFromSourceCode(workspace, execArch);
        Iterable $this$map$iv = workspace.getDataStructs();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CodeDataStruct codeDataStruct = (CodeDataStruct)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getPackage());
        }
        List packages = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        CodeStructureStyle layeredStyle = new LayeredIdentify(packages).identify();
        execArch.setLayeredStyle(layeredStyle);
        switch (WhenMappings.$EnumSwitchMapping$0[layeredStyle.ordinal()]) {
            case 1: {
                Iterable $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                destination$iv$iv = workspace.getDataStructs();
                object = execArch;
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    CodeDataStruct it = (CodeDataStruct)element$iv$iv;
                    boolean bl = false;
                    if (!StringsKt.contains$default((CharSequence)it.getNodeName(), (CharSequence)"Entity", (boolean)false, (int)2, null)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                ((PotentialExecArch)object).setConcepts((List)destination$iv$iv2);
                break;
            }
            case 2: 
            case 3: {
                Iterable $this$filter$iv = workspace.getDataStructs();
                object = execArch;
                boolean $i$f$filter = false;
                Iterable $this$filterTo$iv$iv = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    CodeDataStruct it = (CodeDataStruct)element$iv$iv;
                    boolean bl = false;
                    if (!(StringsKt.contains$default((CharSequence)it.getPackage(), (CharSequence)"domain", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)it.getNodeName(), (CharSequence)"Factory", (boolean)false, (int)2, null))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                ((PotentialExecArch)object).setConcepts((List)destination$iv$iv2);
            }
        }
        return execArch;
    }

    private final void fillArchFromSourceCode(Workspace workspace, PotentialExecArch execArch) {
        Iterable $this$forEach$iv = workspace.getDataStructs();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeImport it;
            CodeImport element$iv2;
            int n;
            CodeDataStruct struct = (CodeDataStruct)element$iv;
            boolean bl = false;
            CodeImport[] $this$forEach$iv2 = struct.getImports();
            boolean $i$f$forEach2 = false;
            int n2 = $this$forEach$iv2.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv2 = $this$forEach$iv2[n];
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getSource(), (Object)"java.io.File")) continue;
                execArch.setConnectorTypes(CollectionsKt.plus((Collection)execArch.getConnectorTypes(), (Object)((Object)ConnectorType.FileIO)));
            }
            $this$forEach$iv2 = struct.getFunctionCalls();
            $i$f$forEach2 = false;
            n2 = $this$forEach$iv2.length;
            for (n = 0; n < n2; ++n) {
                it = element$iv2 = $this$forEach$iv2[n];
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getNodeName(), (Object)"ProcessBuilder")) continue;
                execArch.setConnectorTypes(CollectionsKt.plus((Collection)execArch.getConnectorTypes(), (Object)((Object)ConnectorType.Process)));
            }
        }
    }

    @NotNull
    public final PotentialExecArch inferenceExecArchByDependencies(@NotNull FrameworkMarkup markup, @NotNull PackageDependencies packageDeps) {
        Intrinsics.checkNotNullParameter((Object)markup, (String)"markup");
        Intrinsics.checkNotNullParameter((Object)packageDeps, (String)"packageDeps");
        PotentialExecArch potentialExecArch = new PotentialExecArch(null, null, null, null, null, null, 63, null);
        HashMap<String, String> appTypeMap = markup.getDepAppTypeMap();
        HashMap<String, String> protocols = markup.getDepProtocolMap();
        List<String> coreStacks = markup.getCoreStacks();
        Iterable $this$forEach$iv = packageDeps.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object it;
            DependencyEntry depEntry = (DependencyEntry)element$iv;
            boolean bl = false;
            Object $this$forEach$iv2 = appTypeMap;
            boolean $i$f$forEach2 = false;
            for (Map.Entry element$iv2 : $this$forEach$iv2.entrySet()) {
                it = element$iv2;
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((String)depEntry.getName(), (String)((String)it.getKey()), (boolean)false, (int)2, null)) continue;
                potentialExecArch.setAppTypes(CollectionsKt.plus((Collection)potentialExecArch.getAppTypes(), it.getValue()));
            }
            $this$forEach$iv2 = protocols;
            $i$f$forEach2 = false;
            for (Map.Entry element$iv2 : $this$forEach$iv2.entrySet()) {
                it = element$iv2;
                boolean bl3 = false;
                if (!StringsKt.startsWith$default((String)depEntry.getName(), (String)((String)it.getKey()), (boolean)false, (int)2, null)) continue;
                potentialExecArch.setProtocols(CollectionsKt.plus((Collection)potentialExecArch.getProtocols(), it.getValue()));
            }
            $this$forEach$iv2 = coreStacks;
            $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv2.iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv2;
                element$iv2 = iterator.next();
                it = (String)((Object)element$iv2);
                boolean bl4 = false;
                if (!StringsKt.startsWith$default((String)depEntry.getName(), (String)it, (boolean)false, (int)2, null)) continue;
                potentialExecArch.setCoreStacks(CollectionsKt.plus((Collection)potentialExecArch.getCoreStacks(), (Object)it));
            }
        }
        return potentialExecArch;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CodeStructureStyle.values().length];
            nArray[CodeStructureStyle.MVC.ordinal()] = 1;
            nArray[CodeStructureStyle.ModuleDDD.ordinal()] = 2;
            nArray[CodeStructureStyle.DDD.ordinal()] = 3;
            nArray[CodeStructureStyle.CLEAN.ordinal()] = 4;
            nArray[CodeStructureStyle.UNKNOWN.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

