/*
 * Decompiled with CFR 0.152.
 */
package org.arakhne.afc.bootique.applicationdata2.modules;

import com.google.common.base.Strings;
import com.google.inject.AbstractModule;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.matcher.AbstractMatcher;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.ProvisionListener;
import io.bootique.meta.application.ApplicationMetadata;
import java.lang.reflect.Field;
import org.arakhne.afc.bootique.applicationdata2.annotations.DefaultApplicationName;

public class ApplicationMetadata2Module
extends AbstractModule {
    protected void configure() {
        this.binder().bindListener((Matcher)new BindingMatcher(), new ProvisionListener[]{new ApplicationProvisionListener((Provider<Injector>)this.binder().getProvider(Injector.class))});
    }

    private static class BindingMatcher
    extends AbstractMatcher<Binding<?>> {
        BindingMatcher() {
        }

        public boolean matches(Binding<?> binding) {
            return ApplicationMetadata.class.isAssignableFrom(binding.getKey().getTypeLiteral().getRawType());
        }
    }

    private static class ApplicationProvisionListener
    implements ProvisionListener {
        private final Provider<Injector> injector;

        ApplicationProvisionListener(Provider<Injector> provider) {
            this.injector = provider;
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provisionInvocation) {
            Object object = provisionInvocation.provision();
            if (object instanceof ApplicationMetadata) {
                String string;
                ApplicationMetadata applicationMetadata = (ApplicationMetadata)object;
                Injector injector = (Injector)this.injector.get();
                try {
                    string = (String)injector.getInstance(Key.get(String.class, DefaultApplicationName.class));
                }
                catch (Throwable throwable) {
                    string = null;
                }
                if (!Strings.isNullOrEmpty(string)) {
                    ApplicationProvisionListener.setName(applicationMetadata, string);
                }
            }
        }

        private static void setName(ApplicationMetadata applicationMetadata, String string) {
            try {
                Field field = ApplicationMetadata.class.getDeclaredField("name");
                field.setAccessible(true);
                field.set(applicationMetadata, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

