/*
 * Decompiled with CFR 0.152.
 */
package org.appspy.perf.servlet.skip;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appspy.perf.servlet.skip.SkipManager;

public class URLBasedSkipManager
implements SkipManager {
    protected static Log sLog = LogFactory.getLog(URLBasedSkipManager.class);
    protected String mURLPattern = null;

    public int skipRequest(ServletRequest req, ServletResponse res, ServletContext sc) {
        int skip = 0;
        if (req instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)req;
            try {
                String contextPath = request.getContextPath();
                String requestURI = request.getRequestURI();
                String result = requestURI.replaceFirst(contextPath, "");
                if (result.matches(this.mURLPattern)) {
                    if (sLog.isDebugEnabled()) {
                        sLog.debug((Object)("Skipping this request : " + result + " matches the URLPattern : " + this.mURLPattern));
                    }
                    skip = 1;
                }
            }
            catch (Exception ex) {
                sLog.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return skip;
    }

    public String getURLPattern() {
        return this.mURLPattern;
    }

    public void setURLPattern(String pattern) {
        this.mURLPattern = pattern;
    }
}

