/*
 * Decompiled with CFR 0.152.
 */
package org.appspy.perf.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.appspy.perf.servlet.AppSpyServletInputStream;
import org.appspy.perf.servlet.AppSpyServletReader;

public class AppSpyServletRequestWrapper
extends HttpServletRequestWrapper {
    protected AppSpyServletInputStream mPerfServletInputStream = null;
    protected AppSpyServletReader mPerfServletReader = null;
    protected LinkedList<String> mRequestDispatcherServiceStack = new LinkedList();

    public AppSpyServletRequestWrapper(HttpServletRequest req) {
        super(req);
    }

    public ServletInputStream getInputStream() throws IOException {
        ServletInputStream sis = super.getInputStream();
        this.mPerfServletInputStream = new AppSpyServletInputStream(sis);
        return this.mPerfServletInputStream;
    }

    public BufferedReader getReader() throws IOException {
        BufferedReader br = super.getReader();
        this.mPerfServletReader = new AppSpyServletReader(br);
        return this.mPerfServletReader;
    }

    public int getBytesRead() {
        if (this.mPerfServletReader != null) {
            return this.mPerfServletReader.getTotalRead();
        }
        if (this.mPerfServletInputStream != null) {
            return this.mPerfServletInputStream.getTotalRead();
        }
        return 0;
    }

    public void pushRequestDispatcherService(String service) {
        this.mRequestDispatcherServiceStack.addLast(service);
    }

    public String peekRequestDispatcherService() {
        return this.mRequestDispatcherServiceStack.getLast();
    }

    public String popRequestDispatcherService() {
        return this.mRequestDispatcherServiceStack.removeLast();
    }
}

