/*
 * Decompiled with CFR 0.152.
 */
package org.appspy.perf.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appspy.client.common.Collector;
import org.appspy.client.common.CollectorFactory;
import org.appspy.client.common.CollectorInfo;
import org.appspy.core.data.CollectedData;
import org.appspy.perf.data.ServletTimerData;
import org.appspy.perf.servlet.AppSpyServletRequestWrapper;
import org.appspy.perf.servlet.AppSpyServletResponseWrapper;
import org.appspy.perf.servlet.AppSpyWebappManagerFactory;
import org.appspy.perf.servlet.provider.DataProvider;
import org.appspy.perf.servlet.skip.SkipManager;

public class AppSpyFilter
implements Filter {
    protected Log sLog = LogFactory.getLog(AppSpyFilter.class);
    protected FilterConfig mFilterConfig = null;

    public void destroy() {
        AppSpyWebappManagerFactory.getAppSpyWebappManager(this.mFilterConfig.getServletContext()).destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        this.sLog.debug((Object)"Entering into AppSpyFilter");
        CollectorInfo collectorInfo = CollectorFactory.getCollectorInfo();
        if (this.sLog.isDebugEnabled()) {
            this.sLog.debug((Object)("AppSpy Collector Status is " + collectorInfo.getStatus()));
        }
        boolean skipRequest = false;
        if (collectorInfo.getStatus() == 2 || collectorInfo.getStatus() == 1) {
            this.sLog.debug((Object)"AppSpyFilter will skip this request (cause : status)");
            skipRequest = true;
        } else {
            SkipManager skipManager = AppSpyWebappManagerFactory.getAppSpyWebappManager(this.mFilterConfig.getServletContext()).getSkipManager();
            int skipRequestResult = skipManager.skipRequest(req, res, this.mFilterConfig.getServletContext());
            boolean bl = skipRequest = skipRequestResult == 1;
        }
        if (skipRequest) {
            chain.doFilter(req, res);
        } else {
            ServletTimerData servletTimerData;
            Collector collector;
            DataProvider servletTimerDataProvider;
            Throwable resultThrowable;
            AppSpyServletResponseWrapper responseWrapper;
            AppSpyServletRequestWrapper requestWrapper;
            block23: {
                this.sLog.debug((Object)"AppSpyFilter starts the processing of request");
                HttpServletRequest request = (HttpServletRequest)req;
                HttpServletResponse response = (HttpServletResponse)res;
                requestWrapper = new AppSpyServletRequestWrapper(request);
                responseWrapper = new AppSpyServletResponseWrapper(response);
                resultThrowable = null;
                servletTimerDataProvider = null;
                collector = null;
                servletTimerData = new ServletTimerData();
                try {
                    collector = CollectorFactory.getCollector();
                    this.sLog.debug((Object)"Starting data collection");
                    collector.beginCollection((CollectedData)servletTimerData);
                    servletTimerDataProvider = AppSpyWebappManagerFactory.getAppSpyWebappManager(this.mFilterConfig.getServletContext()).getWebappDataProvider();
                    if (this.sLog.isDebugEnabled()) {
                        this.sLog.debug((Object)("Using this dataProvider : " + servletTimerDataProvider));
                    }
                    this.sLog.debug((Object)"servletTimerDataProvider.beforeRequest");
                    servletTimerDataProvider.beforeRequest(servletTimerData, (HttpServletRequest)requestWrapper, (HttpServletResponse)responseWrapper, this.mFilterConfig.getServletContext());
                }
                catch (Throwable t) {
                    this.sLog.error((Object)"Error while processing the request", t);
                    if (collectorInfo == null) break block23;
                    collectorInfo.setStatus(3, t);
                }
            }
            try {
                this.sLog.debug((Object)"Before chain.doFilter");
                chain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
                this.sLog.debug((Object)"After return of chain.doFilter");
            }
            catch (Throwable t) {
                resultThrowable = t;
                this.sLog.debug((Object)"After throwable of chain.doFilter");
            }
            finally {
                block25: {
                    try {
                        servletTimerData.setTimerType(0);
                        this.sLog.debug((Object)"servletTimerDataProvider.afterRequest");
                        servletTimerDataProvider.afterRequest(servletTimerData, (HttpServletRequest)requestWrapper, (HttpServletResponse)responseWrapper, this.mFilterConfig.getServletContext(), resultThrowable);
                        this.sLog.debug((Object)"End of data collection");
                        collector.endCollection();
                    }
                    catch (Throwable t) {
                        this.sLog.error((Object)"Error while collecting data", t);
                        if (collectorInfo == null) break block25;
                        collectorInfo.setStatus(3, t);
                    }
                }
            }
            if (resultThrowable != null) {
                if (resultThrowable instanceof IOException) {
                    throw (IOException)resultThrowable;
                }
                if (resultThrowable instanceof ServletException) {
                    throw (ServletException)resultThrowable;
                }
                if (resultThrowable instanceof RuntimeException) {
                    throw (RuntimeException)resultThrowable;
                }
                throw new RuntimeException(resultThrowable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig config) throws ServletException {
        this.mFilterConfig = config;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Collector.class.getClassLoader());
            AppSpyWebappManagerFactory.initAppSpyWebappManager(config.getServletContext());
        }
        catch (Throwable t) {
            this.sLog.error((Object)"Error in init of AppSpyFilter", t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

