/**
 * Copyright (c) 2008 appspy.org, Contributors.
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 *
 * You may obtain a copy of the License at 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the 
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language governing permissions 
 * and limitations under the License. */
package org.appspy.perf.servlet.skip;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Olivier HEDIN / olivier@appspy.org
 */
public class URLBasedSkipManager implements SkipManager
{
	protected static Log sLog = LogFactory.getLog(URLBasedSkipManager.class);
	
	protected String mURLPattern = null;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.appspy.perf.servlet.skip.SkipManager#skipRequest(javax.servlet.ServletRequest,
	 *      javax.servlet.ServletResponse, javax.servlet.ServletContext)
	 */
	public int skipRequest(ServletRequest req, ServletResponse res, ServletContext sc)
	{
		int skip = SkipManager.UNDEFINED;

		if (req instanceof HttpServletRequest)
		{
			HttpServletRequest request = (HttpServletRequest) req;
			
			try
			{
				String contextPath = request.getContextPath();
				String requestURI = request.getRequestURI();
				String result = requestURI.replaceFirst(contextPath, "");
				
				if (result.matches(mURLPattern))
				{
					if (sLog.isDebugEnabled())
					{
						sLog.debug("Skipping this request : " + result + " matches the URLPattern : " + mURLPattern);
					}
					skip = SkipManager.SKIP;
				}
			}
			catch (Exception ex)
			{
				sLog.warn(ex.getMessage(), ex);
			}
		}

		return skip;
	}

	/**
     * @return the uRLPattern
     */
    public String getURLPattern()
    {
    	return mURLPattern;
    }

	/**
     * @param pattern the uRLPattern to set
     */
    public void setURLPattern(String pattern)
    {
    	mURLPattern = pattern;
    }

}
