/*
 * Copyright (c) 2008 appspy.org, Contributors.
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 
 * Unless required by applicable law or agreed to in writing, software distributed under the 
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language governing permissions 
 * and limitations under the License. */

package org.appspy.perf.servlet.provider;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.appspy.perf.data.ServletTimerData;

/**
 * @author Olivier HEDIN / olivier@appspy.org
 */
public interface DataProvider {
	
	public void beforeRequest(ServletTimerData servletTimerData, HttpServletRequest req, HttpServletResponse res, ServletContext servletContext);
	
	public void afterRequest(ServletTimerData servletTimerData, HttpServletRequest req, HttpServletResponse res, ServletContext servletContext, Throwable throwable);

}
