/*
 * Copyright (c) 2008 appspy.org, Contributors.
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 
 * Unless required by applicable law or agreed to in writing, software distributed under the 
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language governing permissions 
 * and limitations under the License. */

package org.appspy.perf.servlet.provider;

import java.util.HashMap;
import java.util.WeakHashMap;

import org.appspy.core.data.CollectedData;

/**
 * @author Olivier HEDIN / olivier@appspy.org
 */
public abstract class AbstractDataProvider implements DataProvider {
	

	protected WeakHashMap<CollectedData, HashMap<String, Object>> mDataMap = new WeakHashMap<CollectedData, HashMap<String,Object>>();
	
	public AbstractDataProvider()
	{
	}
	
	protected void setAttribute(CollectedData collectedData, String key, Object value)
	{
		getDataMap(collectedData).put(key, value);
	}
	
	protected Object getAttribute(CollectedData collectedData, String key)
	{
		return getDataMap(collectedData).get(key);
	}
	
	protected HashMap<String, Object> getDataMap(CollectedData collectedData)
	{
		HashMap<String, Object> result = null;
		
		if (!mDataMap.containsKey(collectedData))
		{
			result = new HashMap<String, Object>();
			mDataMap.put(collectedData, result);
		}
		else
		{
			result = mDataMap.get(collectedData);
		}
		
		return result;
	}
}
