/*
 * Copyright (c) 2008 appspy.org, Contributors.
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 
 * Unless required by applicable law or agreed to in writing, software distributed under the 
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language governing permissions 
 * and limitations under the License. */

package org.appspy.perf.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;

import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class AppSpyServletRequestWrapper extends HttpServletRequestWrapper
{
	protected AppSpyServletInputStream mPerfServletInputStream = null;
	protected AppSpyServletReader mPerfServletReader = null;
	
	protected LinkedList<String> mRequestDispatcherServiceStack = new LinkedList<String>();

	public AppSpyServletRequestWrapper(HttpServletRequest req)
	{
		super(req);
	}

	public ServletInputStream getInputStream() throws IOException
	{
		ServletInputStream sis = super.getInputStream();
		mPerfServletInputStream = new AppSpyServletInputStream(sis);
		
		return mPerfServletInputStream;
	}

	public BufferedReader getReader() throws IOException
	{
		BufferedReader br = super.getReader();
		mPerfServletReader = new AppSpyServletReader(br);
		
		return mPerfServletReader;
	}

	public int getBytesRead()
	{
		if (mPerfServletReader != null)
		{
			return mPerfServletReader.getTotalRead();
		}
		else if (mPerfServletInputStream != null) 
		{
			return mPerfServletInputStream.getTotalRead();
		}
		
		return 0;
	}
	
	public void pushRequestDispatcherService(String service)
	{
		mRequestDispatcherServiceStack.addLast(service);
	}
	
	public String peekRequestDispatcherService()
	{
		return mRequestDispatcherServiceStack.getLast();
	}
	
	public String popRequestDispatcherService()
	{
		return mRequestDispatcherServiceStack.removeLast();
	}
}
