/*
 * Copyright (c) 2008 appspy.org, Contributors.
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 
 * Unless required by applicable law or agreed to in writing, software distributed under the 
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language governing permissions 
 * and limitations under the License. */

package org.appspy.perf.servlet;

import java.io.IOException;

import javax.servlet.ServletOutputStream;

public class AppSpyServletOutputStream extends ServletOutputStream
{
	protected ServletOutputStream mServletOutputStream = null;
	protected int mTotalWritten = 0;
	
	public AppSpyServletOutputStream(ServletOutputStream sos)
	{
		mServletOutputStream = sos;
	}

	public void print(boolean b) throws IOException
	{
		mServletOutputStream.print(b);
		
		mTotalWritten = mTotalWritten + 1;
	}

	public void print(char c) throws IOException
	{
		mServletOutputStream.print(c);
		
		mTotalWritten = mTotalWritten + 1;
	}

	public void print(double d) throws IOException
	{
		mServletOutputStream.print(d);
		
		mTotalWritten = mTotalWritten + String.valueOf(d).length();
	}

	public void print(float f) throws IOException
	{
		mServletOutputStream.print(f);
		
		mTotalWritten = mTotalWritten + String.valueOf(f).length();
	}

	public void print(int i) throws IOException
	{
		mServletOutputStream.print(i);
		
		mTotalWritten = mTotalWritten + String.valueOf(i).length();
	}

	public void print(long l) throws IOException
	{
		mServletOutputStream.print(l);
		
		mTotalWritten = mTotalWritten + String.valueOf(l).length();
	}

	public void print(String s) throws IOException
	{
		mServletOutputStream.print(s);
		
		if (s != null)
		{
			mTotalWritten = mTotalWritten + s.length();
		}
	}

	public void println() throws IOException
	{
		mServletOutputStream.println();
		
		mTotalWritten = mTotalWritten + System.getProperty("line.separator", "\n").length();
	}

	public void println(boolean b) throws IOException
	{
		mServletOutputStream.println(b);
		
		mTotalWritten = mTotalWritten + 1 + System.getProperty("line.separator", "\n").length();
	}

	public void println(char c) throws IOException
	{
		mServletOutputStream.print(c);
		
		mTotalWritten = mTotalWritten + 1 + System.getProperty("line.separator", "\n").length();
	}

	public void println(double d) throws IOException
	{
		mServletOutputStream.print(d);
		
		mTotalWritten = mTotalWritten + String.valueOf(d).length() + System.getProperty("line.separator", "\n").length();
	}

	public void println(float f) throws IOException
	{
		mServletOutputStream.print(f);
		
		mTotalWritten = mTotalWritten + String.valueOf(f).length() + System.getProperty("line.separator", "\n").length();
	}

	public void println(int i) throws IOException
	{
		mServletOutputStream.print(i);
		
		mTotalWritten = mTotalWritten + String.valueOf(i).length() + System.getProperty("line.separator", "\n").length();
	}

	public void println(long l) throws IOException
	{
		mServletOutputStream.print(l);
		
		mTotalWritten = mTotalWritten + String.valueOf(l).length() + System.getProperty("line.separator", "\n").length();
	}

	public void println(String s) throws IOException
	{
		mServletOutputStream.print(s);
		
		if (s != null)
		{
			mTotalWritten = mTotalWritten + s.length() + System.getProperty("line.separator", "\n").length();
		}
	}

	public void close() throws IOException
	{
		mServletOutputStream.close();
	}

	public void flush() throws IOException
	{
		mServletOutputStream.flush();
	}

	public void write(byte[] b, int off, int len) throws IOException
	{
		mServletOutputStream.write(b, off, len);
		
		if (b != null)
		{
			mTotalWritten = mTotalWritten + len - off;
		}
	}

	public void write(byte[] b) throws IOException
	{
		mServletOutputStream.write(b);
		
		if (b != null)
		{
			mTotalWritten = mTotalWritten + b.length;
		}
	}

	public void write(int b) throws IOException
	{
		mServletOutputStream.write(b);
		
		mTotalWritten = mTotalWritten + String.valueOf(b).length();
	}
	
	public int getTotalWritten()
	{
		return mTotalWritten;
	}
	
}
