/*
 * Copyright (c) 2008 appspy.org, Contributors.
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 
 * Unless required by applicable law or agreed to in writing, software distributed under the 
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language governing permissions 
 * and limitations under the License. */

package org.appspy.perf.servlet;

import java.io.IOException;

import javax.servlet.ServletInputStream;

public class AppSpyServletInputStream extends ServletInputStream
{
	protected int mTotalRead = 0;
	protected ServletInputStream mServletInputStream = null;
	
	public AppSpyServletInputStream(ServletInputStream sis)
	{
		mServletInputStream = sis;
	}

	public int readLine(byte[] b, int off, int len) throws IOException
	{
		int read = mServletInputStream.readLine(b, off, len);
		
		if (read > 0)
		{
			mTotalRead = mTotalRead + read;
		}
		
		return read;
	}

	public int read() throws IOException
	{
		int read = mServletInputStream.read();
		
		if (read > 0)
		{
			mTotalRead = mTotalRead + 1;
		}
		
		return read;
	}

	public int available() throws IOException
	{
		return mServletInputStream.available();
	}

	public void close() throws IOException
	{
		mServletInputStream.close();
	}

	public synchronized void mark(int readlimit)
	{
		mServletInputStream.mark(readlimit);
	}

	public boolean markSupported()
	{
		return mServletInputStream.markSupported();
	}

	public int read(byte[] b, int off, int len) throws IOException
	{
		int read = mServletInputStream.read(b, off, len);
		
		if (read > 0)
		{
			mTotalRead = mTotalRead + read;
		}
		
		return read;
	}

	public int read(byte[] b) throws IOException
	{
		int read = mServletInputStream.read(b);
		
		if (read > 0)
		{
			mTotalRead = mTotalRead + read;
		}
		
		return read;
	}

	public synchronized void reset() throws IOException
	{
		mServletInputStream.reset();
	}

	public long skip(long n) throws IOException
	{
		return mServletInputStream.skip(n);
	}
	
	public int getTotalRead()
	{
		return mTotalRead;
	}

	
}
