/*
 * Copyright (c) 2008 appspy.org, Contributors.
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 
 * Unless required by applicable law or agreed to in writing, software distributed under the 
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language governing permissions 
 * and limitations under the License. */

package org.appspy.perf.servlet;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

/**
 * @author Olivier HEDIN / olivier@appspy.org
 */
public class AppSpyRequestDispatcher implements RequestDispatcher {
	
	protected RequestDispatcher mWrappedRequestDispatcher = null;
	protected String mService = null;
	
	public AppSpyRequestDispatcher(String service, RequestDispatcher rd)
	{
		mService = service;
		mWrappedRequestDispatcher = rd;
	}

	/* (non-Javadoc)
	 * @see javax.servlet.RequestDispatcher#forward(javax.servlet.ServletRequest, javax.servlet.ServletResponse)
	 */
	public void forward(ServletRequest req, ServletResponse res) throws ServletException, IOException {
		if (req instanceof AppSpyServletRequestWrapper)
		{
			((AppSpyServletRequestWrapper) req).pushRequestDispatcherService(mService);
		}
		
		Throwable throwable = null;
		try
		{
			mWrappedRequestDispatcher.forward(req, res);
		}
		catch (Throwable t)
		{
			throwable = t;
		}
		finally
		{
			if (req instanceof AppSpyServletRequestWrapper)
			{
				((AppSpyServletRequestWrapper) req).popRequestDispatcherService();
			}
			if (throwable != null)
			{
				throwThrowable(throwable);
			}
		}
	}

	/* (non-Javadoc)
	 * @see javax.servlet.RequestDispatcher#include(javax.servlet.ServletRequest, javax.servlet.ServletResponse)
	 */
	public void include(ServletRequest req, ServletResponse res) throws ServletException, IOException {
		if (req instanceof AppSpyServletRequestWrapper)
		{
			((AppSpyServletRequestWrapper) req).pushRequestDispatcherService(mService);
		}
		
		Throwable throwable = null;
		try
		{
			mWrappedRequestDispatcher.include(req, res);
		}
		catch (Throwable t)
		{
			throwable = t;
		}
		finally
		{
			if (req instanceof AppSpyServletRequestWrapper)
			{
				((AppSpyServletRequestWrapper) req).popRequestDispatcherService();
			}
			if (throwable != null)
			{
				throwThrowable(throwable);
			}
		}
	}
	
	protected void throwThrowable(Throwable throwable) throws ServletException, IOException
	{
		if (throwable instanceof ServletException)
		{
			throw (ServletException) throwable;
		}
		else if (throwable instanceof IOException)
		{
			throw (IOException) throwable;
		}
		else if (throwable instanceof RuntimeException)
		{
			throw (RuntimeException) throwable;
		}
		else if (throwable instanceof Error)
		{
			throw (Error) throwable;
		}
		else
		{
			throw new ServletException(throwable);
		}
	}

}
