/*
 * Decompiled with CFR 0.152.
 */
package org.appspy.perf.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.appspy.client.common.CollectorFactory;
import org.appspy.client.common.CollectorInfo;

public class AppspyStatusServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        CollectorInfo collectorInfo = CollectorFactory.getCollectorInfo();
        res.setContentType("text/html");
        res.setDateHeader("Expires", 0L);
        res.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
        res.setHeader("Pragma", "no-cache");
        String status = "Unknown";
        if (collectorInfo.getStatus() == 2) {
            status = "Bad Config";
        } else if (collectorInfo.getStatus() == 3) {
            status = "Error";
        } else if (collectorInfo.getStatus() == 0) {
            status = "Running";
        } else if (collectorInfo.getStatus() == 1) {
            status = "Stopped";
        }
        PrintWriter pw = res.getWriter();
        pw.println("<html>");
        pw.println("\t<head>");
        pw.println("\t\t<title>Appspy status</title>");
        pw.println("\t</head>");
        pw.println("\t<body>");
        pw.println("\t\t<table>");
        pw.println("\t\t\t<tr>");
        pw.println("\t\t\t\t<td>Status</td>");
        pw.println("\t\t\t\t<td>" + status + "</td>");
        pw.println("\t\t\t</tr>");
        pw.println("\t\t\t<tr>");
        pw.println("\t\t\t\t<td>Exception</td>");
        if (collectorInfo.getThrowable() == null) {
            pw.println("\t\t\t\t<td>None</td>");
        } else {
            pw.println("\t\t\t\t<td>");
            pw.println(collectorInfo.getThrowable().getLocalizedMessage());
            for (StackTraceElement ste : collectorInfo.getThrowable().getStackTrace()) {
                pw.println(ste.toString());
            }
            pw.println("\t\t\t\t</td>");
        }
        pw.println("\t\t\t</tr>");
        pw.println("\t\t</table>");
        pw.println("\t</body>");
        pw.println("</html>");
    }
}

