/*
 * Decompiled with CFR 0.152.
 */
package org.appspy.perf.servlet;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appspy.client.common.Collector;
import org.appspy.client.common.CollectorFactory;
import org.appspy.client.common.config.ConfigLoader;
import org.appspy.client.common.config.FileConfigLoader;
import org.appspy.perf.servlet.AppSpyWebappManager;

public class AppSpyWebappManagerFactory {
    public static final String APPSPY_WEBAPP_MANAGER = "org.appspy.webapp.manager";
    public static final String WEBAPP_CONFIG_LOADER_PARAM_NAME = "org.appspy.webappConfigLoader";
    public static final String DEFAULT_WEBAPP_CONFIG_LOADER = FileConfigLoader.class.getName();
    public static final String WEBAPP_CONFIG_PATTERN_PARAM_NAME = "org.appspy.webappConfigPattern";
    public static final String DEFAULT_WEBAPP_CONFIG_PATTERN = "appspy-webapp-{0}.xml";
    protected static Log sLog = LogFactory.getLog(AppSpyWebappManagerFactory.class);
    protected static Integer sLock = new Integer(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initAppSpyWebappManager(ServletContext servletContext) throws Exception {
        AppSpyWebappManager result = null;
        result = (AppSpyWebappManager)servletContext.getAttribute(APPSPY_WEBAPP_MANAGER);
        if (result == null) {
            Integer n = sLock;
            synchronized (n) {
                result = (AppSpyWebappManager)servletContext.getAttribute(APPSPY_WEBAPP_MANAGER);
                if (result == null) {
                    sLog.info((Object)"Creation of the AppSpyWebappManager");
                    if (sLog.isInfoEnabled()) {
                        sLog.info((Object)("Using appspy dir : " + CollectorFactory.getAppspyDir()));
                    }
                    Properties configProperties = AppSpyWebappManagerFactory.getConfigProperties(servletContext);
                    AppSpyWebappManagerFactory.initCollector(servletContext, configProperties);
                    File appSpyLibDir = new File(CollectorFactory.getAppspyDir(), "client/servlet/lib");
                    File[] libs = appSpyLibDir.listFiles(new FileFilter(){

                        public boolean accept(File pathname) {
                            return pathname.isFile() && pathname.getName().endsWith(".jar");
                        }
                    });
                    ArrayList<URL> urls = new ArrayList<URL>();
                    for (File file : libs) {
                        try {
                            urls.add(file.toURL());
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    }
                    if (sLog.isInfoEnabled()) {
                        sLog.info((Object)("Libraries used in the webappManager classloader : " + urls));
                    }
                    String webappConfigLoaderClassName = DEFAULT_WEBAPP_CONFIG_LOADER;
                    if (servletContext.getInitParameter(WEBAPP_CONFIG_LOADER_PARAM_NAME) != null) {
                        webappConfigLoaderClassName = servletContext.getInitParameter(WEBAPP_CONFIG_LOADER_PARAM_NAME);
                    }
                    ConfigLoader webappConfigLoader = (ConfigLoader)Class.forName(webappConfigLoaderClassName, true, Thread.currentThread().getContextClassLoader()).newInstance();
                    String webappConfigPattern = DEFAULT_WEBAPP_CONFIG_PATTERN;
                    if (servletContext.getInitParameter(WEBAPP_CONFIG_PATTERN_PARAM_NAME) != null) {
                        webappConfigPattern = servletContext.getInitParameter(WEBAPP_CONFIG_PATTERN_PARAM_NAME);
                    }
                    String webappConfigLocation = MessageFormat.format(webappConfigPattern, CollectorFactory.getAppspyMode());
                    URL webappConfigURL = webappConfigLoader.getURL(webappConfigLocation);
                    URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
                    try {
                        Class<?> managerClass = Class.forName("org.appspy.perf.servlet.internal.AppSpyWebappManagerImpl", true, cl);
                        result = (AppSpyWebappManager)managerClass.newInstance();
                        result.init(configProperties, webappConfigURL);
                        servletContext.setAttribute(APPSPY_WEBAPP_MANAGER, (Object)result);
                    }
                    catch (Exception e) {
                        sLog.error((Object)"Error in webappManager initialization", (Throwable)e);
                        CollectorFactory.getCollectorInfo().setStatus(2, (Throwable)e);
                    }
                }
            }
        }
    }

    protected static Collector initCollector(ServletContext servletContext, Properties configProperties) throws Exception {
        String collectorConfigLoaderClassName = CollectorFactory.DEFAULT_COLLECTOR_CONFIG_LOADER;
        if (servletContext.getInitParameter("org.appspy.collectorConfigLoader") != null) {
            collectorConfigLoaderClassName = servletContext.getInitParameter("org.appspy.collectorConfigLoader");
        }
        ConfigLoader collectorConfigLoader = (ConfigLoader)Class.forName(collectorConfigLoaderClassName, true, Thread.currentThread().getContextClassLoader()).newInstance();
        String collectorConfigPattern = "appspy-collector-{0}.xml";
        if (servletContext.getInitParameter("org.appspy.collectorConfigPattern") != null) {
            collectorConfigPattern = servletContext.getInitParameter("org.appspy.collectorConfigPattern");
        }
        String collectorConfigLocation = MessageFormat.format(collectorConfigPattern, CollectorFactory.getAppspyMode());
        URL collectorConfigURL = collectorConfigLoader.getURL(collectorConfigLocation);
        Collector collector = CollectorFactory.initCollector((Properties)configProperties, (URL)collectorConfigURL);
        return collector;
    }

    public static AppSpyWebappManager getAppSpyWebappManager(ServletContext servletContext) {
        AppSpyWebappManager result = null;
        result = (AppSpyWebappManager)servletContext.getAttribute(APPSPY_WEBAPP_MANAGER);
        return result;
    }

    protected static Properties getConfigProperties(ServletContext servletContext) throws Exception {
        String propertiesConfigLoaderClassName = CollectorFactory.DEFAULT_PROPERTIES_CONFIG_LOADER;
        if (servletContext.getInitParameter("org.appspy.propertiesConfigLoader") != null) {
            propertiesConfigLoaderClassName = servletContext.getInitParameter("org.appspy.propertiesConfigLoader");
        }
        ConfigLoader propertiesConfigLoader = (ConfigLoader)Class.forName(propertiesConfigLoaderClassName, true, Thread.currentThread().getContextClassLoader()).newInstance();
        String propertiesConfigPattern = "appspy-config-{0}.properties";
        if (servletContext.getInitParameter("org.appspy.propertiesConfigPattern") != null) {
            propertiesConfigPattern = servletContext.getInitParameter("org.appspy.propertiesConfigPattern");
        }
        String propertiesConfigLocation = MessageFormat.format(propertiesConfigPattern, CollectorFactory.getAppspyMode());
        Properties properties = propertiesConfigLoader.loadConfig(propertiesConfigLocation);
        return properties;
    }
}

