/**
 * Copyright (c) 2008 appspy.org, Contributors.
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 *
 * You may obtain a copy of the License at 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the 
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language governing permissions 
 * and limitations under the License. */
package org.appspy.perf.servlet.skip;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/**
 * @author Olivier HEDIN / olivier@appspy.org
 */
public class NoSessionSamplingSkipManager implements SkipManager
{
	protected static int mCollectedDataCounter = 0;

	protected int mSampling = 1;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.appspy.perf.servlet.skip.SkipManager#skipRequest(javax.servlet.ServletRequest,
	 *      javax.servlet.ServletResponse, javax.servlet.ServletContext)
	 */
	public int skipRequest(ServletRequest req, ServletResponse res, ServletContext sc)
	{
		int skip = SkipManager.UNDEFINED;

		if (req instanceof HttpServletRequest)
		{
			HttpServletRequest request = (HttpServletRequest) req;
			HttpSession session = request.getSession(false);
			if (session == null)
			{
				mCollectedDataCounter++;
				if (mCollectedDataCounter % mSampling == 0)
				{
					mCollectedDataCounter = 0;
					skip = SkipManager.COLLECT;
				} else
				{
					skip = SkipManager.SKIP;
				}
			}
		}

		return skip;
	}

	/**
	 * @return the sampling
	 */
	public int getSampling()
	{
		return mSampling;
	}

	/**
	 * @param sampling
	 *            the sampling to set
	 */
	public void setSampling(int sampling)
	{
		mSampling = sampling;
	}

}
