/**
 * Copyright (c) 2008 appspy.org, Contributors.
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 *
 * You may obtain a copy of the License at 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the 
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language governing permissions 
 * and limitations under the License. */
package org.appspy.perf.servlet.skip;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

/**
 * @author Olivier HEDIN / olivier@appspy.org
 */
public class HeaderBasedSkipManager implements SkipManager
{
	protected String mHeaderName = null;
	protected String mHeaderValuePattern = null;

	/* (non-Javadoc)
	 * @see org.appspy.perf.servlet.skip.SkipManager#skipRequest(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.ServletContext)
	 */
	public int skipRequest(ServletRequest req, ServletResponse res, ServletContext sc)
	{
		int skip = SkipManager.UNDEFINED;

		if (req instanceof HttpServletRequest)
		{
			HttpServletRequest request = (HttpServletRequest) req;
			if (request.getHeader(mHeaderName) != null && request.getHeader(mHeaderName).matches(mHeaderValuePattern))
			{
				skip = SkipManager.SKIP;
			}
		}

		return skip;
	}

	/**
     * @return the headerName
     */
    public String getHeaderName()
    {
    	return mHeaderName;
    }

	/**
     * @param headerName the headerName to set
     */
    public void setHeaderName(String headerName)
    {
    	mHeaderName = headerName;
    }

	/**
     * @return the headerValuePattern
     */
    public String getHeaderValuePattern()
    {
    	return mHeaderValuePattern;
    }

	/**
     * @param headerValuePattern the headerValuePattern to set
     */
    public void setHeaderValuePattern(String headerValuePattern)
    {
    	mHeaderValuePattern = headerValuePattern;
    }
}
