/**
 * Copyright (c) 2008 appspy.org, Contributors.
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 *
 * You may obtain a copy of the License at 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the 
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language governing permissions 
 * and limitations under the License. */
package org.appspy.perf.servlet.skip;

import java.util.List;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * @author Olivier HEDIN / olivier@appspy.org
 */
public class CompositeSkipManager implements SkipManager
{
	protected static Log sLog = LogFactory.getLog(CompositeSkipManager.class);
	
	protected List<SkipManager> mSkipManagers = null;

	/* (non-Javadoc)
	 * @see org.appspy.perf.servlet.skip.SkipManager#skipRequest(javax.servlet.ServletRequest, javax.servlet.ServletResponse, javax.servlet.ServletContext)
	 */
	public int skipRequest(ServletRequest req, ServletResponse res, ServletContext sc)
	{
		int skip = SkipManager.COLLECT;
		
		for (SkipManager skipManager : mSkipManagers)
        {
			int result = skipManager.skipRequest(req, res, sc);
	        if (result != SkipManager.UNDEFINED)
	        {
	        	skip = result;
	        	if (sLog.isDebugEnabled())
	        	{
	        		if (skip == SkipManager.SKIP)
	        		{
	        			sLog.debug("Skipping this request because of " + skipManager);
	        		}
	        		else
	        		{
	        			sLog.debug("Collecting this request because of " + skipManager);
	        		}
	        	}
	        	break;
	        }
        }
		return skip;
	}

	/**
     * @return the skipManagers
     */
    public List<SkipManager> getSkipManagers()
    {
    	return mSkipManagers;
    }

	/**
     * @param skipManagers the skipManagers to set
     */
    public void setSkipManagers(List<SkipManager> skipManagers)
    {
    	mSkipManagers = skipManagers;
    }
}
