/**
 * Copyright (c) 2008 appspy.org, Contributors.
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 *
 * You may obtain a copy of the License at 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the 
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language governing permissions 
 * and limitations under the License. */
package org.appspy.perf.servlet;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.appspy.client.common.CollectorFactory;
import org.appspy.client.common.CollectorInfo;

/**
 * @author Olivier HEDIN / olivier@appspy.org
 */
@SuppressWarnings("serial")
public class AppspyStatusServlet extends HttpServlet
{
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
    {
		CollectorInfo collectorInfo = CollectorFactory.getCollectorInfo();
		res.setContentType("text/html");
		res.setDateHeader("Expires", 0);
		res.setHeader("Cache-Control", "no-store, no-cache, must-revalidate");
		res.setHeader("Pragma", "no-cache");
		
		String status = "Unknown";
		if (collectorInfo.getStatus() == CollectorInfo.STATUS_BAD_CONFIG)
		{
			status = "Bad Config";
		}
		else if (collectorInfo.getStatus() == CollectorInfo.STATUS_ERROR)
		{
			status = "Error";
		}
		else if (collectorInfo.getStatus() == CollectorInfo.STATUS_RUNNING)
		{
			status = "Running";
		}
		else if (collectorInfo.getStatus() == CollectorInfo.STATUS_STOPPED)
		{
			status = "Stopped";
		}
		
		PrintWriter pw = res.getWriter();
		pw.println("<html>");
		pw.println("	<head>");
		pw.println("		<title>Appspy status</title>");
		pw.println("	</head>");
		pw.println("	<body>");
		pw.println("		<table>");
		pw.println("			<tr>");
		pw.println("				<td>Status</td>");
		pw.println("				<td>" + status + "</td>");
		pw.println("			</tr>");
		pw.println("			<tr>");
		pw.println("				<td>Exception</td>");
		if (collectorInfo.getThrowable() == null)
		{
			pw.println("				<td>None</td>");
		}
		else
		{
			pw.println("				<td>");
			pw.println(collectorInfo.getThrowable().getLocalizedMessage());
			for (StackTraceElement ste : collectorInfo.getThrowable().getStackTrace())
            {
	            pw.println(ste.toString());
            }
			pw.println("				</td>");
		}
		pw.println("			</tr>");
//		pw.println("			<tr>");
//		pw.println("				<td>Data collected count</td>");
//		pw.println("				<td>" + collectorInfo.getTotalHits() + "</td>");
//		pw.println("			</tr>");
//		pw.println("			<tr>");
//		pw.println("				<td>Data send count</td>");
//		pw.println("				<td>" + collectorInfo.getTotalCollected() + "</td>");
//		pw.println("			</tr>");
		pw.println("		</table>");
		pw.println("	</body>");
		pw.println("</html>");
    }

}
