/**
 * Copyright (c) 2008 appspy.org, Contributors.
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 *
 * You may obtain a copy of the License at 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the 
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language governing permissions 
 * and limitations under the License. */
package org.appspy.perf.servlet;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.appspy.client.common.CollectorFactory;
import org.appspy.client.common.CollectorInfo;

/**
 * @author Olivier HEDIN / olivier@appspy.org
 */
@SuppressWarnings("serial")
public class AppspyControlServlet extends HttpServlet
{
    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException
    {
		CollectorInfo collectorInfo = CollectorFactory.getCollectorInfo();
		
		String requestedStatus = req.getParameter("status");
		if ("start".equalsIgnoreCase(requestedStatus))
		{
			collectorInfo.setStatus(CollectorInfo.STATUS_RUNNING, null);
		}
		else if ("stop".equalsIgnoreCase(requestedStatus))
		{
			collectorInfo.setStatus(CollectorInfo.STATUS_STOPPED, null);
		}
		
		
		req.getRequestDispatcher("/appspy-status").forward(req, res);
    }

}
