/*
 * Copyright (c) 2008 appspy.org, Contributors.
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 
 * Unless required by applicable law or agreed to in writing, software distributed under the 
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language governing permissions 
 * and limitations under the License. */

package org.appspy.perf.servlet;

import java.io.PrintWriter;
import java.io.Writer;

public class AppSpyServletWriter extends PrintWriter
{
	protected int mTotalWritten = 0;
	protected boolean mIsNested = false;

	public AppSpyServletWriter(Writer out)
	{
		super(out);
	}

	/*
	public void print(boolean b)
	{
		if (mIsNested)
		{
			super.print(b);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.print(b);
				
				mTotalRead = mTotalRead + 1;
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void print(char c)
	{
		if (mIsNested)
		{
			super.print(c);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.print(c);
				
				mTotalRead = mTotalRead + Character.SIZE;
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void print(char[] s)
	{
		if (mIsNested)
		{
			super.print(s);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.print(s);
				
				if (s != null)
				{
					mTotalRead = mTotalRead + s.length;
				}
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void print(double d)
	{
		if (mIsNested)
		{
			super.print(d);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.print(d);
				
				mTotalRead = mTotalRead + Double.SIZE;
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void print(float f)
	{
		if (mIsNested)
		{
			super.print(f);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.print(f);
				
				mTotalRead = mTotalRead + Float.SIZE;
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void print(int i)
	{
		if (mIsNested)
		{
			super.print(i);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.print(i);
				
				mTotalRead = mTotalRead + Integer.SIZE;
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void print(long l)
	{
		if (mIsNested)
		{
			super.print(l);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.print(l);
				
				mTotalRead = mTotalRead + Long.SIZE;
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void print(Object obj)
	{
		if (mIsNested)
		{
			super.print(obj);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			String s = String.valueOf(obj);
			
			try
			{
				super.write(s);
				
				if (s != null)
				{
					mTotalRead = mTotalRead + s.getBytes().length*Byte.SIZE;
				}
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void print(String s)
	{
		if (mIsNested)
		{
			super.print(s);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.print(s);
				
				if (s != null)
				{
					mTotalRead = mTotalRead + s.getBytes().length*Byte.SIZE;
				}
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void println()
	{
		if (mIsNested)
		{
			super.println();
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.println();
				
				mTotalRead = mTotalRead + System.getProperty("line.separator", "\n").getBytes().length*Byte.SIZE;
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void println(boolean b)
	{
		if (mIsNested)
		{
			super.println(b);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.println(b);
				
				mTotalRead = mTotalRead + 1 + System.getProperty("line.separator", "\n").getBytes().length*Byte.SIZE;
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void println(char c)
	{
		if (mIsNested)
		{
			super.println(c);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.println(c);
				
				mTotalRead = mTotalRead + Character.SIZE + System.getProperty("line.separator", "\n").getBytes().length*Byte.SIZE;
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void println(char[] c)
	{
		if (mIsNested)
		{
			super.println(c);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.println(c);
				
				if (c != null)
				{
					mTotalRead = mTotalRead + c.length*Character.SIZE + System.getProperty("line.separator", "\n").getBytes().length*Byte.SIZE;
				}
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void println(double d)
	{
		if (mIsNested)
		{
			super.println(d);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.println(d);
				
				mTotalRead = mTotalRead + Double.SIZE + System.getProperty("line.separator", "\n").getBytes().length*Byte.SIZE;
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void println(float f)
	{
		if (mIsNested)
		{
			super.println(f);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.println(f);
				
				mTotalRead = mTotalRead + Float.SIZE + System.getProperty("line.separator", "\n").getBytes().length*Byte.SIZE;
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void println(int i)
	{
		if (mIsNested)
		{
			super.println(i);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.println(i);
				
				mTotalRead = mTotalRead + Integer.SIZE + System.getProperty("line.separator", "\n").getBytes().length*Byte.SIZE;
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void println(long l)
	{
		if (mIsNested)
		{
			super.println(l);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.println(l);
				
				mTotalRead = mTotalRead + Long.SIZE + System.getProperty("line.separator", "\n").getBytes().length*Byte.SIZE;
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void println(Object o)
	{
		if (mIsNested)
		{
			super.println(o);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			String s = String.valueOf(o);
			try
			{
				super.println(s);
				
				if (s != null)
				{
					mTotalRead = mTotalRead + s.getBytes().length*Byte.SIZE + System.getProperty("line.separator", "\n").getBytes().length*Byte.SIZE;
				}
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void println(String s)
	{
		if (mIsNested)
		{
			super.println(s);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.println(s);
				
				if (s != null)
				{
					mTotalRead = mTotalRead + s.getBytes().length*Byte.SIZE + System.getProperty("line.separator", "\n").getBytes().length*Byte.SIZE;
				}
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}
	*/

	public void write(char[] buf, int off, int len)
	{
		if (mIsNested)
		{
			super.write(buf, off, len);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.write(buf, off, len);
				
				mTotalWritten = mTotalWritten + (len - off);
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}
	
	/*

	public void write(char[] buf)
	{
		if (mIsNested)
		{
			super.write(buf);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.write(buf);
				
				if (buf != null)
				{
					mTotalRead = mTotalRead + buf.length*Character.SIZE;
				}
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	public void write(int c)
	{
		if (mIsNested)
		{
			super.write(c);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.write(c);
				
				mTotalRead = mTotalRead + Integer.SIZE;
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}
	
	*/

	public void write(String s, int off, int len)
	{
		if (mIsNested)
		{
			super.write(s, off, len);
		}
		else
		{
			mIsNested = true;
			RuntimeException runtimeException = null;

			try
			{
				super.write(s, off, len);
				
				mTotalWritten = mTotalWritten + (len - off);
			}
			catch (RuntimeException ex)
			{
				runtimeException = ex;
			}
			finally
			{
				mIsNested = false;
				if (runtimeException != null)
				{
					throw runtimeException;
				}
			}
		}
	}

	/*
	public void write(String s)
	{
		// TODO Auto-generated method stub
		super.write(s);
	}
	*/
	
	public int getTotalWritten()
	{
		return mTotalWritten;
	}
}
