/*
 * Copyright (c) 2008 appspy.org, Contributors.
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 
 * Unless required by applicable law or agreed to in writing, software distributed under the 
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language governing permissions 
 * and limitations under the License. */

package org.appspy.perf.servlet;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class AppSpyServletResponseWrapper extends HttpServletResponseWrapper
{
	protected int mStatus = 200;
	
	protected AppSpyServletOutputStream mPerfServletOutputStream = null;
	protected AppSpyServletWriter mPerfServletWriter = null;

	public AppSpyServletResponseWrapper(HttpServletResponse res)
	{
		super(res);
	}

	public void sendError(int code, String msg) throws IOException
	{
		mStatus = code;
		super.sendError(code, msg);
	}

	public void sendError(int code) throws IOException
	{
		mStatus = code;
		super.sendError(code);
	}

	public void setStatus(int code, String msg)
	{
		mStatus = code;
		super.setStatus(code, msg);
	}

	/* (non-Javadoc)
	 * @see javax.servlet.http.HttpServletResponseWrapper#setStatus(int)
	 */
	public void setStatus(int code)
	{
		mStatus = code;
		super.setStatus(code);
	}
	
	/* (non-Javadoc)
     * @see javax.servlet.http.HttpServletResponseWrapper#sendRedirect(java.lang.String)
     */
    @Override
    public void sendRedirect(String location) throws IOException
    {
    	mStatus = HttpServletResponse.SC_TEMPORARY_REDIRECT;
	    super.sendRedirect(location);
    }

	public int getStatus()
	{
		return mStatus;
	}

	public ServletOutputStream getOutputStream() throws IOException
	{
		ServletOutputStream sos = super.getOutputStream();
		mPerfServletOutputStream = new AppSpyServletOutputStream(sos);
		
		return mPerfServletOutputStream;
	}

	public PrintWriter getWriter() throws IOException
	{
		PrintWriter pw = super.getWriter();
		mPerfServletWriter = new AppSpyServletWriter(pw);
		
		return mPerfServletWriter;
	}
	
	public int getBytesWritten()
	{
		if (mPerfServletWriter != null)
		{
			return mPerfServletWriter.getTotalWritten();
		}
		else if (mPerfServletOutputStream != null) 
		{
			return mPerfServletOutputStream.getTotalWritten();
		}
		
		return 0;
	}
}
