/*
 * Decompiled with CFR 0.152.
 */
package org.appspy.perf.servlet.internal;

import java.net.URL;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appspy.client.common.CollectorFactory;
import org.appspy.perf.servlet.AppSpyWebappManager;
import org.appspy.perf.servlet.provider.DataProvider;
import org.appspy.perf.servlet.skip.SkipManager;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class AppSpyWebappManagerImpl
implements AppSpyWebappManager {
    protected Log sLog = LogFactory.getLog(AppSpyWebappManagerImpl.class);
    protected GenericApplicationContext mApplicationContext = null;
    protected DataProvider mWebappDataProvider = null;
    protected SkipManager mSkipManager = null;

    public void init(Properties configProperties, URL webappConfigURL) {
        this.mApplicationContext = new GenericApplicationContext();
        this.mApplicationContext.setClassLoader(this.getClass().getClassLoader());
        PropertyPlaceholderConfigurer ppc = new PropertyPlaceholderConfigurer();
        ppc.setProperties(configProperties);
        this.mApplicationContext.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)ppc);
        XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)this.mApplicationContext);
        xmlReader.loadBeanDefinitions((Resource)new UrlResource(webappConfigURL));
        this.mApplicationContext.refresh();
        this.mWebappDataProvider = (DataProvider)this.mApplicationContext.getBean("webappDataProvider");
        this.mSkipManager = (SkipManager)this.mApplicationContext.getBean("skipManager");
    }

    public DataProvider getWebappDataProvider() {
        return this.mWebappDataProvider;
    }

    public SkipManager getSkipManager() {
        return this.mSkipManager;
    }

    public void destroy() {
        CollectorFactory.getCollector().destroy();
    }
}

