/*
 * Copyright (c) 2008 appspy.org, Contributors.
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0 
 * Unless required by applicable law or agreed to in writing, software distributed under the 
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, 
 * either express or implied. See the License for the specific language governing permissions 
 * and limitations under the License. */

package org.appspy.perf.servlet.internal;

import java.net.URL;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.appspy.client.common.Collector;
import org.appspy.client.common.CollectorFactory;
import org.appspy.perf.servlet.AppSpyWebappManager;
import org.appspy.perf.servlet.provider.DataProvider;
import org.appspy.perf.servlet.skip.SkipManager;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.UrlResource;

/**
 * @author Olivier HEDIN / olivier@appspy.org
 */
public class AppSpyWebappManagerImpl implements AppSpyWebappManager {
	
	protected Log sLog = LogFactory.getLog(AppSpyWebappManagerImpl.class);

	protected GenericApplicationContext mApplicationContext = null;
	
	protected DataProvider mWebappDataProvider = null;
	protected SkipManager mSkipManager = null;

	public void init(Properties configProperties, URL webappConfigURL) {

		mApplicationContext = new GenericApplicationContext();
		mApplicationContext.setClassLoader(this.getClass().getClassLoader());
		PropertyPlaceholderConfigurer ppc = new PropertyPlaceholderConfigurer();
		ppc.setProperties(configProperties);
		mApplicationContext.addBeanFactoryPostProcessor(ppc);
		XmlBeanDefinitionReader xmlReader = new XmlBeanDefinitionReader(mApplicationContext);
		xmlReader.loadBeanDefinitions(new UrlResource(webappConfigURL));
		mApplicationContext.refresh();
		
		mWebappDataProvider = (DataProvider) mApplicationContext.getBean("webappDataProvider");
		mSkipManager = (SkipManager) mApplicationContext.getBean("skipManager");
	}

	public DataProvider getWebappDataProvider()
	{
		return mWebappDataProvider;
	}

	/* (non-Javadoc)
     * @see org.appspy.perf.servlet.AppSpyWebappManager#getSkipManager()
     */
    public SkipManager getSkipManager()
    {
	    return mSkipManager;
    }

	/* (non-Javadoc)
     * @see org.appspy.perf.servlet.AppSpyWebappManager#destroy()
     */
    public void destroy()
    {
    	CollectorFactory.getCollector().destroy();
    }
	
	
}
