/*
 * Decompiled with CFR 0.152.
 */
package org.appng.api.rest.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Objects;

@ApiModel(description="Marks a field as sortable, properties are filled only when sorting has been applied.")
public class Sort
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="prio")
    private Integer prio = null;
    @JsonProperty(value="order")
    private OrderEnum order = null;

    public Sort prio(Integer prio) {
        this.prio = prio;
        return this;
    }

    @ApiModelProperty(value="The priority for this sort, important when a multi-field sort is applied.")
    public Integer getPrio() {
        return this.prio;
    }

    public void setPrio(Integer prio) {
        this.prio = prio;
    }

    public Sort order(OrderEnum order) {
        this.order = order;
        return this;
    }

    @ApiModelProperty(value="The order for this sort (ascending or descending).")
    public OrderEnum getOrder() {
        return this.order;
    }

    public void setOrder(OrderEnum order) {
        this.order = order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sort sort = (Sort)o;
        return Objects.equals(this.prio, sort.prio) && Objects.equals((Object)this.order, (Object)sort.order);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.prio, this.order});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Sort {\n");
        sb.append("    prio: ").append(this.toIndentedString(this.prio)).append("\n");
        sb.append("    order: ").append(this.toIndentedString((Object)this.order)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum OrderEnum {
        ASC("asc"),
        DESC("desc");

        private String value;

        private OrderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static OrderEnum fromValue(String text) {
            for (OrderEnum b : OrderEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

