/*
 * Decompiled with CFR 0.152.
 */
package org.appng.api.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.appng.api.rest.model.Parameter;

@ApiModel(description="A validation rule that can be bound to an action-field.")
public class ValidationRule
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="message")
    private String message = null;
    @JsonProperty(value="active")
    private Boolean active = null;
    @JsonProperty(value="messageKey")
    private String messageKey = null;
    @JsonProperty(value="options")
    private List<Parameter> options = null;

    public ValidationRule type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="The type of the rule.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public ValidationRule message(String message) {
        this.message = message;
        return this;
    }

    @ApiModelProperty(value="The error message displayed when the rule isn't fulfilled.")
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public ValidationRule active(Boolean active) {
        this.active = active;
        return this;
    }

    @ApiModelProperty(value="Whether or not this rule is active, meaning it should be applied.")
    public Boolean isActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public ValidationRule messageKey(String messageKey) {
        this.messageKey = messageKey;
        return this;
    }

    @ApiModelProperty(value="The message key for this rule")
    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public ValidationRule options(List<Parameter> options) {
        this.options = options;
        return this;
    }

    public ValidationRule addOptionsItem(Parameter optionsItem) {
        if (this.options == null) {
            this.options = new ArrayList<Parameter>();
        }
        this.options.add(optionsItem);
        return this;
    }

    @ApiModelProperty(value="An array defining the custom parameters for this rule.")
    public List<Parameter> getOptions() {
        return this.options;
    }

    public void setOptions(List<Parameter> options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationRule validationRule = (ValidationRule)o;
        return Objects.equals(this.type, validationRule.type) && Objects.equals(this.message, validationRule.message) && Objects.equals(this.active, validationRule.active) && Objects.equals(this.messageKey, validationRule.messageKey) && Objects.equals(this.options, validationRule.options);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.message, this.active, this.messageKey, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ValidationRule {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    messageKey: ").append(this.toIndentedString(this.messageKey)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

