/*
 * Decompiled with CFR 0.152.
 */
package org.appng.api.rest.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.appng.api.rest.model.Element;

@ApiModel(description="A page that contains paging information an a list of elements.")
public class Page
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="number")
    private Integer number = null;
    @JsonProperty(value="size")
    private Integer size = null;
    @JsonProperty(value="totalPages")
    private Integer totalPages = null;
    @JsonProperty(value="totalElements")
    private Integer totalElements = null;
    @JsonProperty(value="isFirst")
    private Boolean isFirst = null;
    @JsonProperty(value="isLast")
    private Boolean isLast = null;
    @JsonProperty(value="elements")
    private List<Element> elements = null;

    public Page number(Integer number) {
        this.number = number;
        return this;
    }

    @ApiModelProperty(value="The 0-based number of the current page.")
    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public Page size(Integer size) {
        this.size = size;
        return this;
    }

    @ApiModelProperty(value="The number of elements per page.")
    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Page totalPages(Integer totalPages) {
        this.totalPages = totalPages;
        return this;
    }

    @ApiModelProperty(value="The number of total pages.")
    public Integer getTotalPages() {
        return this.totalPages;
    }

    public void setTotalPages(Integer totalPages) {
        this.totalPages = totalPages;
    }

    public Page totalElements(Integer totalElements) {
        this.totalElements = totalElements;
        return this;
    }

    @ApiModelProperty(value="The total number of elements.")
    public Integer getTotalElements() {
        return this.totalElements;
    }

    public void setTotalElements(Integer totalElements) {
        this.totalElements = totalElements;
    }

    public Page isFirst(Boolean isFirst) {
        this.isFirst = isFirst;
        return this;
    }

    @ApiModelProperty(value="If this is the first page.")
    public Boolean isIsFirst() {
        return this.isFirst;
    }

    public void setIsFirst(Boolean isFirst) {
        this.isFirst = isFirst;
    }

    public Page isLast(Boolean isLast) {
        this.isLast = isLast;
        return this;
    }

    @ApiModelProperty(value="If this is the last page.")
    public Boolean isIsLast() {
        return this.isLast;
    }

    public void setIsLast(Boolean isLast) {
        this.isLast = isLast;
    }

    public Page elements(List<Element> elements) {
        this.elements = elements;
        return this;
    }

    public Page addElementsItem(Element elementsItem) {
        if (this.elements == null) {
            this.elements = new ArrayList<Element>();
        }
        this.elements.add(elementsItem);
        return this;
    }

    @ApiModelProperty(value="The elements of this page.")
    public List<Element> getElements() {
        return this.elements;
    }

    public void setElements(List<Element> elements) {
        this.elements = elements;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Page page = (Page)o;
        return Objects.equals(this.number, page.number) && Objects.equals(this.size, page.size) && Objects.equals(this.totalPages, page.totalPages) && Objects.equals(this.totalElements, page.totalElements) && Objects.equals(this.isFirst, page.isFirst) && Objects.equals(this.isLast, page.isLast) && Objects.equals(this.elements, page.elements);
    }

    public int hashCode() {
        return Objects.hash(this.number, this.size, this.totalPages, this.totalElements, this.isFirst, this.isLast, this.elements);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Page {\n");
        sb.append("    number: ").append(this.toIndentedString(this.number)).append("\n");
        sb.append("    size: ").append(this.toIndentedString(this.size)).append("\n");
        sb.append("    totalPages: ").append(this.toIndentedString(this.totalPages)).append("\n");
        sb.append("    totalElements: ").append(this.toIndentedString(this.totalElements)).append("\n");
        sb.append("    isFirst: ").append(this.toIndentedString(this.isFirst)).append("\n");
        sb.append("    isLast: ").append(this.toIndentedString(this.isLast)).append("\n");
        sb.append("    elements: ").append(this.toIndentedString(this.elements)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

